/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import uk.joshiejack.husbandry.api.HusbandryAPI;
import uk.joshiejack.husbandry.api.IMobStats;
import uk.joshiejack.husbandry.block.HusbandryBlocks;
import uk.joshiejack.husbandry.crafting.HusbandryRegistries;
import uk.joshiejack.penguinlib.item.crafting.AbstractSimplePenguinRecipe;

public class IncubatorRecipe
extends AbstractSimplePenguinRecipe<EntityType<?>> {
    private final RangedInteger amount;

    public IncubatorRecipe(ResourceLocation resource, Ingredient ingredient, EntityType<?> entity, RangedInteger amount) {
        super(HusbandryRegistries.INCUBATOR, (IRecipeSerializer)HusbandryRegistries.INCUBATOR_SERIALIZER.get(), resource, ingredient, entity);
        this.amount = amount;
    }

    public void hatch(ServerWorld world, BlockPos pos, ItemStack stack) {
        for (int i = 0; i < this.amount.func_233018_a_(world.field_73012_v); ++i) {
            IMobStats<AgeableEntity> babyStats;
            Entity entity = ((EntityType)this.output).func_200721_a((World)world);
            if (entity == null) {
                return;
            }
            if (entity instanceof MobEntity) {
                ((MobEntity)entity).func_82227_f(true);
            }
            if (entity instanceof SlimeEntity) {
                try {
                    ObfuscationReflectionHelper.findMethod(SlimeEntity.class, (String)"func_70799_a", (Class[])new Class[]{Integer.TYPE, Boolean.TYPE}).invoke((Object)1, true);
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
            entity.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f, 0.0f);
            if (entity instanceof AgeableEntity && stack.func_77942_o() && stack.func_77978_p().func_74764_b("HeartLevel") && (babyStats = HusbandryAPI.instance.getStatsForEntity((AgeableEntity)entity)) != null) {
                babyStats.increaseHappiness(stack.func_77978_p().func_74762_e("HeartLevel") / 2);
            }
            world.func_217376_c(entity);
        }
    }

    @Nonnull
    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)HusbandryBlocks.INCUBATOR.get());
    }

    public EntityType<?> getEntity() {
        return (EntityType)this.output;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<IncubatorRecipe> {
        @Nonnull
        public IncubatorRecipe fromJson(@Nonnull ResourceLocation resource, @Nonnull JsonObject json) {
            Ingredient ingredient = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
            String s1 = JSONUtils.func_151200_h((JsonObject)json, (String)"entity");
            int low = 0;
            int high = 4;
            if (json.has("min amount")) {
                low = JSONUtils.func_151203_m((JsonObject)json, (String)"min amount");
            }
            if (json.has("max amount")) {
                high = JSONUtils.func_151203_m((JsonObject)json, (String)"max amount");
            }
            if (json.has("amount")) {
                high = low = JSONUtils.func_151203_m((JsonObject)json, (String)"amount");
            }
            EntityType entity = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(s1));
            return new IncubatorRecipe(resource, ingredient, entity, new RangedInteger(low, high));
        }

        @Nonnull
        public IncubatorRecipe fromNetwork(@Nonnull ResourceLocation resource, @Nonnull PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            EntityType entity = (EntityType)buffer.readRegistryIdSafe(EntityType.class);
            RangedInteger integer = new RangedInteger(buffer.readInt(), buffer.readInt());
            return new IncubatorRecipe(resource, ingredient, entity, integer);
        }

        public void toNetwork(@Nonnull PacketBuffer buffer, @Nonnull IncubatorRecipe recipe) {
            recipe.ingredient.func_199564_a(buffer);
            buffer.writeRegistryId((IForgeRegistryEntry)recipe.output);
            buffer.writeInt(recipe.amount.func_233016_a_());
            buffer.writeInt(recipe.amount.func_233019_b_());
        }
    }
}

