/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.data;

import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import uk.joshiejack.husbandry.item.HusbandryItems;

public class HusbandryItemModels
extends ItemModelProvider {
    public HusbandryItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "husbandry", existingFileHelper);
    }

    private boolean isFeed(String path) {
        return path.contains("feed") || path.contains("food") || path.equals("fodder") | path.equals("slop");
    }

    private void registerModels(DeferredRegister<Item> items) {
        items.getEntries().stream().map(RegistryObject::get).forEach(item -> {
            String path = Objects.requireNonNull(item.getRegistryName()).func_110623_a();
            if (item instanceof BlockItem) {
                ((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + path)));
            } else if (path.contains("spawn_egg")) {
                this.withExistingParent(path, this.mcLoc("item/template_spawn_egg"));
            } else {
                String subdir = item.func_219967_s() != null ? "food/" : (path.contains("treat") ? "treat/" : (this.isFeed(path) ? "feed/" : ""));
                this.singleTexture(path, this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + subdir + path.replace("_treat", "")));
            }
        });
    }

    protected void registerModels() {
        this.registerModels(HusbandryItems.ITEMS);
    }
}

