/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.entity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import uk.joshiejack.husbandry.Husbandry;
import uk.joshiejack.husbandry.api.trait.IJoinWorldTrait;
import uk.joshiejack.husbandry.entity.stats.MobStats;
import uk.joshiejack.husbandry.entity.traits.TraitType;

@Mod.EventBusSubscriber(modid="husbandry")
public class MobEventsHandler {
    public static final ITag.INamedTag<Block> PREVENTS_PASSENGER_DROP = BlockTags.createOptional((ResourceLocation)new ResourceLocation("husbandry", "prevents_passenger_drop"));

    @SubscribeEvent
    public static void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        MobStats<?> stats;
        Entity entity = event.getEntity();
        if (!entity.field_70170_p.field_72995_K && entity instanceof MobEntity && (stats = MobStats.getStats(entity)) != null) {
            MobEntity mob = (MobEntity)entity;
            List<IJoinWorldTrait> traits = stats.getTraits(TraitType.ON_JOIN);
            traits.forEach(trait -> trait.onJoinWorld(stats));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        MobStats<?> stats = MobStats.getStats(event.getEntity());
        if (stats != null) {
            stats.decreaseHappiness((int)((float)((Integer)Husbandry.HusbandryConfig.hurtHappinessLossModifier.get()).intValue() * event.getAmount()));
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getPlayer().func_184188_bt().size() > 0 && event.getHand() == Hand.MAIN_HAND) {
            MobEventsHandler.dismountMobs(event.getPlayer());
        } else {
            MobStats<?> stats = MobStats.getStats(event.getTarget());
            if (stats != null) {
                int happiness = stats.getHappiness();
                boolean canceled = stats.onEntityInteract(event.getPlayer(), event.getHand());
                if (canceled) {
                    int newHappiness = stats.getHappiness();
                    if (newHappiness != happiness) {
                        event.getPlayer().func_195068_e((int)Math.ceil((double)(newHappiness - happiness) / 100.0));
                    }
                    event.setCancellationResult(ActionResultType.SUCCESS);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickGround(PlayerInteractEvent.RightClickBlock event) {
        if (!PREVENTS_PASSENGER_DROP.func_230235_a_((Object)event.getWorld().func_180495_p(event.getPos()).func_177230_c())) {
            MobEventsHandler.dismountMobs(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        MobEventsHandler.dismountMobs(event.getPlayer());
    }

    private static void dismountMobs(PlayerEntity player) {
        player.func_184188_bt().stream().filter(entity -> MobStats.getStats(entity) != null).forEach(entity -> {
            entity.func_184210_p();
            entity.field_70177_z = player.field_70177_z;
            entity.field_70125_A = player.field_70125_A;
            entity.func_213309_a(0.0f, new Vector3d((double)0.1f, (double)1.05f, (double)0.1f));
            entity.func_184224_h(false);
        });
    }
}

