/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.entity.ai;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import uk.joshiejack.husbandry.api.IMobStats;
import uk.joshiejack.husbandry.entity.ai.AbstractMoveToBlockGoal;

public class EatTallGrassGoal
extends AbstractMoveToBlockGoal {
    private static final Predicate<BlockState> IS_TALL_GRASS = BlockStateMatcher.func_177638_a((Block)Blocks.field_150349_c);
    private static final Predicate<BlockState> IS_DOUBLE_TALL_GRASS = BlockStateMatcher.func_177638_a((Block)Blocks.field_196804_gh).func_201028_a((Property)DoublePlantBlock.field_176492_b, half -> Objects.equals(half, DoubleBlockHalf.LOWER));

    public EatTallGrassGoal(MobEntity entity, IMobStats<?> stats) {
        super(entity, stats, AbstractMoveToBlockGoal.Orientation.IN, 8);
    }

    @Override
    public boolean func_75250_a() {
        return this.stats.isHungry() && this.entity.func_70681_au().nextInt(50) == 0 && super.func_75250_a();
    }

    @Override
    protected boolean isValidTarget(@Nonnull IWorldReader world, @Nonnull BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return IS_TALL_GRASS.test(state) || IS_DOUBLE_TALL_GRASS.test(state);
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        this.entity.func_70671_ap().func_75650_a((double)this.blockPos.func_177958_n() + 0.5, (double)this.blockPos.func_177956_o(), (double)this.blockPos.func_177952_p() + 0.5, 10.0f, (float)this.entity.func_70646_bf());
        if (this.isNearDestination()) {
            BlockState state = this.entity.field_70170_p.func_180495_p(this.blockPos);
            if (IS_TALL_GRASS.test(state)) {
                if (ForgeEventFactory.getMobGriefingEvent((World)this.entity.field_70170_p, (Entity)this.entity)) {
                    this.entity.field_70170_p.func_175655_b(this.blockPos, false);
                }
                this.stats.feed();
                this.tryTicks = 9999;
            } else if (IS_DOUBLE_TALL_GRASS.test(state)) {
                if (ForgeEventFactory.getMobGriefingEvent((World)this.entity.field_70170_p, (Entity)this.entity)) {
                    this.entity.field_70170_p.func_175655_b(this.blockPos, false);
                    this.entity.field_70170_p.func_180501_a(this.blockPos, Blocks.field_150349_c.func_176223_P(), 2);
                }
                this.stats.feed();
                this.tryTicks = 9999;
            }
        }
    }
}

