/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.entity.stats;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import uk.joshiejack.husbandry.api.IMobStats;
import uk.joshiejack.husbandry.api.trait.IBiHourlyTrait;
import uk.joshiejack.husbandry.entity.stats.CapabilityStatsHandler;
import uk.joshiejack.husbandry.entity.stats.MobStats;
import uk.joshiejack.husbandry.entity.traits.TraitType;
import uk.joshiejack.penguinlib.events.NewDayEvent;

@Mod.EventBusSubscriber(modid="husbandry")
public class MobStatsTicker {
    private static final Set<MobStats<?>> stats = Sets.newHashSet();
    private static List<Runnable> futures = new ArrayList<Runnable>();
    private static boolean iterating;

    @SubscribeEvent
    public static void onNewDay(NewDayEvent event) {
        iterating = true;
        futures.forEach(Runnable::run);
        stats.stream().filter(s -> s.entity.func_70089_S()).forEach(MobStats::onNewDay);
        iterating = false;
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world.func_82737_E() % 2000L == 0L) {
            MobStatsTicker.stats.stream().filter(s -> s.entity.func_70089_S()).forEach(stats -> {
                List<IBiHourlyTrait> traits = stats.getTraits(TraitType.BI_HOURLY);
                traits.forEach(trait -> trait.onBihourlyTick((IMobStats<?>)stats));
            });
        }
    }

    private static void run(Entity entity, Consumer<MobStats<?>> consumer) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        LazyOptional stats = entity.getCapability(CapabilityStatsHandler.MOB_STATS_CAPABILITY);
        if (!stats.isPresent()) {
            return;
        }
        consumer.accept((MobStats<?>)stats.resolve().get());
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (iterating) {
            futures.add(() -> MobStatsTicker.run(event.getEntity(), stats::add));
        } else {
            MobStatsTicker.run(event.getEntity(), stats::add);
        }
    }

    @SubscribeEvent
    public static void onEntityLeaveWorld(EntityLeaveWorldEvent event) {
        if (iterating) {
            futures.add(() -> MobStatsTicker.run(event.getEntity(), stats::add));
        } else {
            MobStatsTicker.run(event.getEntity(), stats::remove);
        }
    }
}

