/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.entity.stats;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import uk.joshiejack.husbandry.Husbandry;
import uk.joshiejack.husbandry.api.ISpecies;
import uk.joshiejack.husbandry.api.trait.IMobTrait;
import uk.joshiejack.husbandry.entity.stats.Products;
import uk.joshiejack.penguinlib.util.icon.ItemIcon;

public class Species
implements ISpecies {
    public static final Map<EntityType<?>, Species> TYPES = Maps.newHashMap();
    public static final Species NONE = new Species(0, 0, Items.field_190931_a, 0, 0, 0, 0, new Products(0, new ResourceLocation(""), ItemIcon.EMPTY), new ArrayList<IMobTrait>());
    private final int minimumLifespan;
    private final int maximumLifespan;
    private final int genericTreats;
    private final int speciesTreats;
    private final int daysToBirth;
    private final int daysToMaturity;
    private final Products products;
    private final List<IMobTrait> traits;
    private final Item treat;

    public Species(int minimumLifespan, int maximumLifespan, Item treat, int genericTreats, int speciesTreats, int daysToBirth, int daysToMaturity, @Nonnull Products products, List<IMobTrait> traits) {
        this.minimumLifespan = minimumLifespan * (Integer)Husbandry.HusbandryConfig.daysPerYear.get();
        this.maximumLifespan = maximumLifespan * (Integer)Husbandry.HusbandryConfig.daysPerYear.get();
        this.treat = treat;
        this.genericTreats = genericTreats;
        this.speciesTreats = speciesTreats;
        this.daysToBirth = daysToBirth;
        this.daysToMaturity = daysToMaturity;
        this.products = products;
        this.traits = traits;
    }

    public int getDaysBetweenProduct() {
        return this.products.getDaysBetweenProducts();
    }

    public List<ItemStack> getProduct(@Nonnull MobEntity entity, @Nullable PlayerEntity player) {
        return this.products.getProduct(entity, player);
    }

    @Override
    public Products getProducts() {
        return this.products;
    }

    @Override
    public int getMinAge() {
        return this.minimumLifespan;
    }

    @Override
    public int getMaxAge() {
        return this.maximumLifespan;
    }

    @Override
    public int getGenericTreats() {
        return this.genericTreats;
    }

    @Override
    public int getSpeciesTreats() {
        return this.speciesTreats;
    }

    @Override
    public int getDaysToBirth() {
        return this.daysToBirth;
    }

    @Override
    public int getDaysToMaturity() {
        return this.daysToMaturity;
    }

    @Override
    public Item getTreat() {
        return this.treat;
    }

    @Override
    public List<IMobTrait> getTraits() {
        return this.traits;
    }
}

