/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.entity.traits.lifestyle;

import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.Lazy;
import uk.joshiejack.husbandry.api.HusbandryAPI;
import uk.joshiejack.husbandry.api.IMobStats;
import uk.joshiejack.husbandry.api.trait.IDataTrait;
import uk.joshiejack.husbandry.api.trait.IIconTrait;
import uk.joshiejack.husbandry.api.trait.IInteractiveTrait;
import uk.joshiejack.husbandry.api.trait.INewDayTrait;
import uk.joshiejack.husbandry.item.HusbandryItems;
import uk.joshiejack.penguinlib.util.icon.Icon;
import uk.joshiejack.penguinlib.util.icon.ItemIcon;

public class MammalTrait
implements IDataTrait,
IInteractiveTrait,
INewDayTrait,
IIconTrait {
    public static final Lazy<Icon> ICON = Lazy.of(() -> new ItemIcon((Item)HusbandryItems.MIRACLE_POTION.get()));
    public static final ITag.INamedTag<Item> IMPREGNATES_MAMMALS = ItemTags.createOptional((ResourceLocation)new ResourceLocation("husbandry", "impregnates_mammals"));
    private int gestation;
    private boolean pregnant;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getIcon(IMobStats<?> stats) {
        return this.pregnant ? (Icon)ICON.get() : ItemIcon.EMPTY;
    }

    @Override
    public void onNewDay(IMobStats<?> stats) {
        if (this.pregnant) {
            --this.gestation;
            if (this.gestation <= 0) {
                this.pregnant = false;
                this.giveBirth(stats);
            }
        }
    }

    @Override
    public boolean onRightClick(IMobStats<?> stats, PlayerEntity player, Hand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (IMPREGNATES_MAMMALS.func_230235_a_((Object)held.func_77973_b()) && !this.pregnant && stats.getSpecies().getDaysToBirth() != 0) {
            this.pregnant = true;
            this.gestation = stats.getSpecies().getDaysToBirth();
            held.func_190918_g(1);
            return true;
        }
        return false;
    }

    public boolean isPregnant() {
        return this.pregnant;
    }

    private void giveBirth(IMobStats<?> stats) {
        Object entity = stats.getEntity();
        stats.increaseHappiness(100);
        int chance = ((MobEntity)entity).field_70170_p.field_73012_v.nextInt(100);
        int offspring = chance >= 99 ? 3 : (chance >= 90 ? 2 : 1);
        for (int i = 0; i < offspring; ++i) {
            if (entity instanceof AgeableEntity) {
                AgeableEntity ageable = ((AgeableEntity)entity).func_241840_a((ServerWorld)((MobEntity)entity).field_70170_p, (AgeableEntity)entity);
                if (ageable == null) continue;
                ageable.func_70873_a(-2147483647);
                ageable.func_70107_b(((MobEntity)entity).field_70169_q, ((MobEntity)entity).field_70167_r, ((MobEntity)entity).field_70166_s);
                IMobStats<AgeableEntity> babyStats = HusbandryAPI.instance.getStatsForEntity(ageable);
                if (babyStats != null) {
                    babyStats.increaseHappiness(stats.getHappiness() / 2);
                }
                ((MobEntity)entity).field_70170_p.func_217376_c((Entity)ageable);
                continue;
            }
            entity.func_200600_R().func_220342_a((ServerWorld)((MobEntity)entity).field_70170_p, null, null, null, entity.func_233580_cy_(), SpawnReason.BREEDING, true, true);
        }
    }

    @Override
    public void save(CompoundNBT tag) {
        tag.func_74768_a("Gestation", this.gestation);
        tag.func_74757_a("Pregnant", this.pregnant);
    }

    @Override
    public void load(CompoundNBT nbt) {
        this.gestation = nbt.func_74762_e("Gestation");
        this.pregnant = nbt.func_74767_n("Pregnant");
    }
}

