/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.entity.traits.product;

import net.minecraft.entity.MobEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import uk.joshiejack.husbandry.api.IMobStats;
import uk.joshiejack.husbandry.api.trait.IDataTrait;
import uk.joshiejack.husbandry.api.trait.IIconTrait;
import uk.joshiejack.husbandry.entity.stats.MobStats;
import uk.joshiejack.husbandry.network.SetProducedProductPacket;
import uk.joshiejack.penguinlib.network.PenguinNetwork;
import uk.joshiejack.penguinlib.network.PenguinPacket;
import uk.joshiejack.penguinlib.util.icon.Icon;

public abstract class AbstractMobProductTrait
implements IIconTrait,
IDataTrait {
    protected int productReset;
    protected int productsProduced;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getIcon(IMobStats<?> stats) {
        return stats.canProduceProduct() ? stats.getSpecies().getProducts().getIcon().shadowed() : stats.getSpecies().getProducts().getIcon();
    }

    public void setProduced(MobStats<?> stats, int amount) {
        if (((MobEntity)stats.getEntity()).field_70170_p.field_72995_K) {
            this.productsProduced = amount;
        } else {
            this.productsProduced += amount;
            PenguinNetwork.sendToNearby((PenguinPacket)new SetProducedProductPacket(stats.getEntity().func_145782_y(), this.productsProduced), stats.getEntity());
        }
    }

    @Override
    public void save(CompoundNBT tag) {
        tag.func_74768_a("ProductReset", this.productReset);
        tag.func_74768_a("ProductsProduced", this.productsProduced);
    }

    @Override
    public void load(CompoundNBT nbt) {
        this.productReset = nbt.func_74762_e("ProductReset");
        this.productsProduced = nbt.func_74762_e("ProductsProduced");
    }
}

