/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.entity.traits.product;

import uk.joshiejack.husbandry.api.IMobStats;
import uk.joshiejack.husbandry.api.trait.IBiHourlyTrait;
import uk.joshiejack.husbandry.api.trait.IInitTrait;
import uk.joshiejack.husbandry.api.trait.INewDayTrait;
import uk.joshiejack.husbandry.entity.traits.product.AbstractMobProductTrait;
import uk.joshiejack.penguinlib.util.helpers.generic.MathsHelper;

public class MoreProductTrait
extends AbstractMobProductTrait
implements IInitTrait,
INewDayTrait,
IBiHourlyTrait {
    private int productsPerDay = 1;

    protected int recalculateProductsPerDay(IMobStats<?> stats) {
        return MathsHelper.convertRange((int)0, (int)stats.getMaxHappiness(), (int)1, (double)5.0, (int)stats.getHappiness());
    }

    @Override
    public void initTrait(IMobStats<?> stats) {
        this.productsPerDay = this.recalculateProductsPerDay(stats);
    }

    @Override
    public void onBihourlyTick(IMobStats<?> stats) {
        if (this.productsProduced < this.productsPerDay) {
            stats.resetProduct();
        }
    }

    @Override
    public void onNewDay(IMobStats<?> stats) {
        ++this.productReset;
        if (this.productReset >= stats.getSpecies().getProducts().getDaysBetweenProducts()) {
            stats.resetProduct();
            this.productReset = 0;
        }
        this.productsPerDay = this.recalculateProductsPerDay(stats);
    }
}

