/*
 * Decompiled with CFR 0.152.
 */
package uk.joshiejack.husbandry.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import uk.joshiejack.husbandry.crafting.HusbandryRegistries;
import uk.joshiejack.husbandry.crafting.IncubatorRecipe;
import uk.joshiejack.husbandry.tileentity.HusbandryTileEntities;
import uk.joshiejack.penguinlib.data.TimeUnitRegistry;
import uk.joshiejack.penguinlib.network.PenguinNetwork;
import uk.joshiejack.penguinlib.network.PenguinPacket;
import uk.joshiejack.penguinlib.network.packet.SetInventorySlotPacket;
import uk.joshiejack.penguinlib.tile.machine.AbstractIRecipeMachine;

public class IncubatorTileEntity
extends AbstractIRecipeMachine<IncubatorRecipe> {
    public static final ModelProperty<ItemStack> ITEM_STACK = new ModelProperty();

    public IncubatorTileEntity() {
        super((TileEntityType)HusbandryTileEntities.INCUBATOR.get(), HusbandryRegistries.INCUBATOR);
    }

    public long getOperationalTime() {
        ItemStack egg = (ItemStack)this.items.get(0);
        if (!egg.func_77942_o() || !egg.func_77978_p().func_74764_b("HatchTime")) {
            return super.getOperationalTime();
        }
        return TimeUnitRegistry.get((String)"day") * (long)egg.func_77978_p().func_74762_e("HatchTime");
    }

    @Nullable
    private EntityType<?> getEntity(ItemStack stack) {
        IncubatorRecipe recipe = (IncubatorRecipe)this.getRecipeResult(stack);
        return recipe == null ? null : recipe.getEntity();
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        return ((ItemStack)this.items.get(slot)).func_190926_b() && this.getEntity(stack) != null;
    }

    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        super.func_70299_a(slot, stack);
        if (this.field_145850_b.field_72995_K) {
            this.requestModelDataUpdate();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int amount) {
        return ItemStack.field_190927_a;
    }

    public void func_70296_d() {
        super.func_70296_d();
        assert (this.field_145850_b != null);
        if (!this.field_145850_b.field_72995_K) {
            PenguinNetwork.sendToNearby((PenguinPacket)new SetInventorySlotPacket(this.field_174879_c, 0, (ItemStack)this.items.get(0)), (TileEntity)this);
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ITEM_STACK, this.items.get(0)).build();
    }

    private boolean isValidSpawnLocation(BlockPos pos) {
        return this.field_145850_b.func_180495_p(pos).isAir((IBlockReader)this.field_145850_b, pos) && this.field_145850_b.func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)this.field_145850_b, pos.func_177977_b(), Direction.UP);
    }

    private List<BlockPos> spawnLocations() {
        HashSet positions = Sets.newHashSet();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            if (!this.isValidSpawnLocation(this.field_174879_c.func_177972_a(dir))) continue;
            positions.add(this.field_174879_c.func_177972_a(dir));
        }
        int loop = 6;
        for (int j = 0; j < loop; ++j) {
            HashSet temp = new HashSet(positions);
            for (BlockPos coord : temp) {
                for (Direction theFacing : Direction.values()) {
                    BlockPos offset = coord.func_177972_a(theFacing);
                    if (!this.isValidSpawnLocation(offset)) continue;
                    positions.add(offset);
                }
            }
        }
        return Lists.newArrayList((Iterable)positions);
    }

    public void finishMachine() {
        List<BlockPos> spawns = this.spawnLocations();
        if (spawns.size() != 0) {
            ((IncubatorRecipe)this.getRecipeResult((ItemStack)this.items.get(0))).hatch((ServerWorld)this.field_145850_b, spawns.get(this.field_145850_b.field_73012_v.nextInt(spawns.size())), (ItemStack)this.items.get(0));
            this.items.set(0, (Object)ItemStack.field_190927_a);
            PenguinNetwork.sendToNearby((PenguinPacket)new SetInventorySlotPacket(this.field_174879_c, 0, ItemStack.field_190927_a), (TileEntity)this);
            this.func_70296_d();
        }
    }
}

