/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import me.hypherionmc.hyperlighting.common.containers.ContainerSwitchBoard;
import me.hypherionmc.hyperlighting.common.tile.TileSwitchBoard;
import me.hypherionmc.hyperlighting.util.SwitchBoardHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.fmlclient.gui.GuiUtils;

public class GuiSwitchBoard
extends AbstractContainerScreen<ContainerSwitchBoard> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("hyperlighting:textures/gui/switchboard_gui.png");
    private final Inventory player;
    private final TileSwitchBoard te;
    private ImageButton buttonImage;
    private List<SwitchBoardHelper> slots = new ArrayList<SwitchBoardHelper>();

    public GuiSwitchBoard(ContainerSwitchBoard containerSwitchBoard, Inventory inventory, Component title) {
        super((AbstractContainerMenu)containerSwitchBoard, inventory, title);
        this.player = inventory;
        this.te = containerSwitchBoard.getTe();
        this.slots.add(new SwitchBoardHelper(new Vec2(17.0f, 36.0f), new Vec2(24.0f, 32.0f), new Vec2(29.0f, 32.0f), new Vec2(43.0f, 14.0f)));
        this.slots.add(new SwitchBoardHelper(new Vec2(66.0f, 36.0f), new Vec2(73.0f, 32.0f), new Vec2(78.0f, 32.0f), new Vec2(92.0f, 14.0f)));
        this.slots.add(new SwitchBoardHelper(new Vec2(115.0f, 36.0f), new Vec2(122.0f, 32.0f), new Vec2(127.0f, 32.0f), new Vec2(141.0f, 14.0f)));
        this.slots.add(new SwitchBoardHelper(new Vec2(17.0f, 66.0f), new Vec2(24.0f, 62.0f), new Vec2(29.0f, 62.0f), new Vec2(43.0f, 44.0f)));
        this.slots.add(new SwitchBoardHelper(new Vec2(66.0f, 66.0f), new Vec2(73.0f, 62.0f), new Vec2(78.0f, 62.0f), new Vec2(92.0f, 44.0f)));
        this.slots.add(new SwitchBoardHelper(new Vec2(115.0f, 66.0f), new Vec2(122.0f, 62.0f), new Vec2(127.0f, 62.0f), new Vec2(141.0f, 44.0f)));
    }

    public void m_7856_() {
        super.m_7856_();
        int id = 0;
        for (SwitchBoardHelper itm : this.slots) {
            int finalId = id++;
            this.buttonImage = new ImageButton(this.f_97735_ + (int)itm.getButtonPos().f_82470_, this.f_97736_ + (int)itm.getButtonPos().f_82471_, 16, 16, 176, 0, 0, TEXTURE, button -> this.actionPerformed(button, finalId));
            this.m_7787_((GuiEventListener)this.buttonImage);
        }
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f_96541_.m_91097_().m_174784_(TEXTURE);
        GuiUtils.drawTexturedModalRect((PoseStack)matrixStack, (int)this.f_97735_, (int)this.f_97736_, (int)0, (int)0, (int)this.f_97726_, (int)this.f_97727_, (float)0.0f);
        for (int j = 0; j < 6; ++j) {
            if (!((Slot)((ContainerSwitchBoard)this.m_6262_()).f_38839_.get(j)).m_6657_() || !this.te.isLinked(j)) continue;
            int i = this.te.getPowerLevel(j);
            SwitchBoardHelper helper = this.slots.get(j);
            GuiUtils.drawTexturedModalRect((PoseStack)matrixStack, (int)(this.f_97735_ + (int)helper.getBarPos().f_82470_), (int)(this.f_97736_ + (int)helper.getBarPos().f_82471_ - i + 1), (int)176, (int)(39 - i), (int)4, (int)(i + 1), (float)1.0f);
            if (this.te.getCharging(j)) {
                GuiUtils.drawTexturedModalRect((PoseStack)matrixStack, (int)(this.f_97735_ + (int)helper.getChargePos().f_82470_), (int)(this.f_97736_ + (int)helper.getChargePos().f_82471_), (int)189, (int)17, (int)4, (int)4, (float)2.0f);
            }
            if (this.te.getState(j)) {
                GuiUtils.drawTexturedModalRect((PoseStack)matrixStack, (int)(this.f_97735_ + (int)helper.getStatepos().f_82470_), (int)(this.f_97736_ + (int)helper.getStatepos().f_82471_), (int)181, (int)17, (int)4, (int)4, (float)3.0f);
                continue;
            }
            GuiUtils.drawTexturedModalRect((PoseStack)matrixStack, (int)(this.f_97735_ + (int)helper.getStatepos().f_82470_), (int)(this.f_97736_ + (int)helper.getStatepos().f_82471_), (int)185, (int)17, (int)4, (int)4, (float)3.0f);
        }
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        this.f_96547_.m_92883_(matrixStack, this.player.m_5446_().getString(), 7.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
        for (int i = 0; i < this.slots.size(); ++i) {
            if (!((Slot)((ContainerSwitchBoard)this.f_97732_).f_38839_.get(i)).m_6657_() || !this.te.isLinked(i)) continue;
            SwitchBoardHelper helper = this.slots.get(i);
            this.drawPowerToolTip(matrixStack, mouseX, mouseY, this.f_97735_ + (int)helper.getBarPos().f_82470_, this.f_97736_ + (int)helper.getBarPos().f_82471_ - 22, 4, 23, "Battery Level", ChatFormatting.YELLOW + Math.round(this.te.getPowerLevelPer(i)) + "%");
            this.drawPowerToolTip(matrixStack, mouseX, mouseY, this.f_97735_ + (int)helper.getChargePos().f_82470_, this.f_97736_ + (int)helper.getChargePos().f_82471_, 4, 4, "Charging State", this.te.getCharging(i) ? ChatFormatting.GREEN + "Charging" : ChatFormatting.RED + "Not Charging");
            this.drawPowerToolTip(matrixStack, mouseX, mouseY, this.f_97735_ + (int)helper.getStatepos().f_82470_, this.f_97736_ + (int)helper.getStatepos().f_82471_, 4, 4, "Power State", this.te.getState(i) ? ChatFormatting.GREEN + "On" : ChatFormatting.RED + "Off");
        }
    }

    private void drawPowerToolTip(PoseStack stack, int mouseX, int mouseY, int startX, int startY, int sizeX, int sizeY, String title, String description) {
        int k = (this.f_96543_ - this.f_97726_) / 2;
        int l = (this.f_96544_ - this.f_97727_) / 2;
        if (mouseX > startX && mouseX < startX + sizeX && mouseY > startY && mouseY < startY + sizeY) {
            ArrayList<TranslatableComponent> list = new ArrayList<TranslatableComponent>();
            list.add(new TranslatableComponent(title));
            list.add(new TranslatableComponent(description));
            GuiUtils.drawHoveringText((PoseStack)stack, list, (int)(mouseX - k), (int)(mouseY - l), (int)this.f_96543_, (int)this.f_96544_, (int)200, (Font)this.f_96547_);
        }
    }

    protected void actionPerformed(Button button, int bid) {
        switch (bid) {
            case 0: {
                if (!((Slot)((ContainerSwitchBoard)this.f_97732_).f_38839_.get(0)).m_6657_()) break;
                this.te.toggleState(0);
                break;
            }
            case 1: {
                if (!((Slot)((ContainerSwitchBoard)this.f_97732_).f_38839_.get(1)).m_6657_()) break;
                this.te.toggleState(1);
                break;
            }
            case 2: {
                if (!((Slot)((ContainerSwitchBoard)this.f_97732_).f_38839_.get(2)).m_6657_()) break;
                this.te.toggleState(2);
                break;
            }
            case 3: {
                if (!((Slot)((ContainerSwitchBoard)this.f_97732_).f_38839_.get(3)).m_6657_()) break;
                this.te.toggleState(3);
                break;
            }
            case 4: {
                if (!((Slot)((ContainerSwitchBoard)this.f_97732_).f_38839_.get(4)).m_6657_()) break;
                this.te.toggleState(4);
                break;
            }
            case 5: {
                if (!((Slot)((ContainerSwitchBoard)this.f_97732_).f_38839_.get(5)).m_6657_()) break;
                this.te.toggleState(5);
            }
        }
    }
}

