/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import me.hypherionmc.hyperlighting.api.DyeAble;
import me.hypherionmc.hyperlighting.api.Lightable;
import me.hypherionmc.hyperlighting.common.config.HyperLightingConfig;
import me.hypherionmc.hyperlighting.common.handlers.ParticleRegistryHandler;
import me.hypherionmc.hyperlighting.common.init.HLItems;
import me.hypherionmc.hyperlighting.common.items.BlockItemWithColoredLight;
import me.hypherionmc.hyperlighting.util.ModUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AdvancedTorchBlock
extends HorizontalDirectionalBlock
implements Lightable,
DyeAble {
    public static final BooleanProperty LIT = BlockStateProperties.f_61448_;
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.m_61587_((String)"color", DyeColor.class);
    public static final EnumProperty<AttachFace> ATTACH_FACE = EnumProperty.m_61598_((String)"face", AttachFace.class, (Enum[])new AttachFace[]{AttachFace.FLOOR, AttachFace.WALL});
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5), (Object)Direction.UP, (Object)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0)));

    public AdvancedTorchBlock(String name, DyeColor color, CreativeModeTab group) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)((Boolean)HyperLightingConfig.torchOnByDefault.get()))).m_61124_(COLOR, (Comparable)color));
        if (ModUtils.isRGBLibPresent()) {
            // empty if block
        }
        HLItems.ITEMS.register(name, () -> new BlockItemWithColoredLight((Block)this, new Item.Properties().m_41491_(group)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((AttachFace)state.m_61143_(ATTACH_FACE)) {
            default: {
                return SHAPES.get(Direction.UP);
            }
            case WALL: 
        }
        return SHAPES.get(state.m_61143_((Property)f_54117_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT, ATTACH_FACE, f_54117_, COLOR});
        super.m_7926_(builder);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        if (direction == Direction.UP) {
            return (BlockState)this.m_49966_().m_61124_(ATTACH_FACE, (Comparable)AttachFace.FLOOR);
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_(ATTACH_FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)f_54117_, (Comparable)direction);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return Blocks.f_50016_.m_49966_();
        }
        for (Direction direction : Direction.values()) {
            if (this.isValidPosition(stateIn, (LevelReader)worldIn, currentPos, direction)) continue;
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean isValidPosition(BlockState state, LevelReader worldIn, BlockPos pos, Direction direction) {
        return AdvancedTorchBlock.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_7495_(), (Direction)direction);
    }

    @Override
    public void toggleLight(Level worldIn, BlockState state, BlockPos pos) {
        state = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)LIT) == false));
        worldIn.m_7731_(pos, state, 2);
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            worldIn.m_5594_((Player)null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.3f, 1.0f);
        }
        worldIn.m_46672_(pos, (Block)this);
    }

    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.m_61143_((Property)LIT)).booleanValue()) {
            SimpleParticleType particleData = (SimpleParticleType)ParticleRegistryHandler.CUSTOM_FLAME.get();
            DyeColor color = (DyeColor)stateIn.m_61143_(COLOR);
            if (stateIn.m_61143_(ATTACH_FACE) == AttachFace.FLOOR) {
                double d0 = (double)pos.m_123341_() + 0.5;
                double d1 = (double)pos.m_123342_() + 0.7;
                double d2 = (double)pos.m_123343_() + 0.5;
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
                worldIn.m_7106_((ParticleOptions)particleData, d0, d1, d2, (double)color.m_41068_()[0], (double)color.m_41068_()[1], (double)color.m_41068_()[2]);
            } else {
                Direction direction = (Direction)stateIn.m_61143_((Property)f_54117_);
                double d0 = (double)pos.m_123341_() + 0.5;
                double d1 = (double)pos.m_123342_() + 0.7;
                double d2 = (double)pos.m_123343_() + 0.5;
                double d3 = 0.22;
                double d4 = 0.27;
                Direction direction1 = direction.m_122424_();
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + 0.27 * (double)direction1.m_122429_(), d1 + 0.22, d2 + 0.27 * (double)direction1.m_122431_(), 0.0, 0.0, 0.0);
                worldIn.m_7106_((ParticleOptions)particleData, d0 + 0.27 * (double)direction1.m_122429_(), d1 + 0.22, d2 + 0.27 * (double)direction1.m_122431_(), (double)color.m_41068_()[0], (double)color.m_41068_()[1], (double)color.m_41068_()[2]);
            }
        }
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)LIT) != false ? 15 : 0;
    }

    @Override
    public BlockColor dyeHandler() {
        return (state, world, pos, tintIndex) -> {
            if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                return ((DyeColor)state.m_61143_(COLOR)).m_41070_();
            }
            return DyeColor.BLACK.m_41070_();
        };
    }

    @Override
    public DyeColor defaultDyeColor() {
        return (DyeColor)this.m_49966_().m_61143_(COLOR);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.f_46443_ && !player.m_21120_(handIn).m_41619_() && player.m_21120_(handIn).m_41720_() instanceof DyeItem) {
            state = (BlockState)state.m_61124_(COLOR, (Comparable)((DyeItem)player.m_21120_(handIn).m_41720_()).m_41089_());
            worldIn.m_7731_(pos, state, 3);
            worldIn.m_7260_(pos, state, state, 3);
            if (!player.m_7500_()) {
                ItemStack stack = player.m_21120_(handIn);
                stack.m_41774_(1);
                player.m_21008_(handIn, stack);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TextComponent(ChatFormatting.YELLOW + "Dyable"));
        tooltip.add((Component)new TextComponent(ChatFormatting.GREEN + "Color: " + this.defaultDyeColor().name()));
        tooltip.add((Component)new TextComponent(ChatFormatting.BLUE + "Colored Lighting Supported"));
        super.m_5871_(stack, worldIn, tooltip, flagIn);
    }
}

