/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.blocks;

import java.util.List;
import javax.annotation.Nullable;
import me.hypherionmc.hyperlighting.HyperLighting;
import me.hypherionmc.hyperlighting.api.DyeAble;
import me.hypherionmc.hyperlighting.api.RemoteSwitchable;
import me.hypherionmc.hyperlighting.common.config.HyperLightingConfig;
import me.hypherionmc.hyperlighting.common.init.HLItems;
import me.hypherionmc.hyperlighting.common.items.BlockItemColor;
import me.hypherionmc.hyperlighting.common.network.PacketHandler;
import me.hypherionmc.hyperlighting.common.network.packets.OpenGUIPacket;
import me.hypherionmc.hyperlighting.common.tile.TileBatteryNeon;
import net.minecraft.ChatFormatting;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BatteryNeon
extends BaseEntityBlock
implements RemoteSwitchable,
DyeAble {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final VoxelShape DOWN_BOUNDING_BOX = Block.m_49796_((double)0.0, (double)0.0, (double)7.008, (double)16.0, (double)3.008, (double)8.992);
    private static final VoxelShape UP_BOUNDING_BOX = Block.m_49796_((double)0.0, (double)12.8, (double)7.008, (double)16.0, (double)16.0, (double)8.992);
    private static final VoxelShape SOUTH_BOUNDING_BOX = Block.m_49796_((double)0.0, (double)7.008, (double)12.992, (double)16.0, (double)8.992, (double)16.0);
    private static final VoxelShape EAST_BOUNDING_BOX = Block.m_49796_((double)0.0, (double)7.008, (double)16.0, (double)12.8, (double)8.992, (double)16.0);
    private static final VoxelShape WEST_BOUNDING_BOX = Block.m_49796_((double)0.0, (double)7.008, (double)0.0, (double)3.2, (double)8.992, (double)16.0);
    private static final VoxelShape NORTH_BOUNDING_BOX = Block.m_49796_((double)0.0, (double)7.008, (double)0.336, (double)16.0, (double)8.992, (double)3.328);

    public BatteryNeon(String name) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60918_(SoundType.f_56744_));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)((Boolean)HyperLightingConfig.batteryOnByDefault.get())));
        HLItems.ITEMS.register(name, () -> new BlockItemColor((Block)this, new Item.Properties().m_41491_((CreativeModeTab)HyperLighting.mainTab)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case UP: {
                return DOWN_BOUNDING_BOX;
            }
            default: {
                return UP_BOUNDING_BOX;
            }
            case NORTH: {
                return SOUTH_BOUNDING_BOX;
            }
            case EAST: {
                return WEST_BOUNDING_BOX;
            }
            case WEST: {
                return EAST_BOUNDING_BOX;
            }
            case SOUTH: 
        }
        return NORTH_BOUNDING_BOX;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.f_46443_ && !Screen.m_96637_()) {
            if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                BlockState oldState = state;
                state = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
                worldIn.m_7731_(pos, state, 3);
                worldIn.m_7260_(pos, oldState, state, 4);
                return InteractionResult.CONSUME;
            }
            if (worldIn.m_7702_(pos) != null && worldIn.m_7702_(pos) instanceof TileBatteryNeon && ((TileBatteryNeon)worldIn.m_7702_(pos)).getPowerLevel() > 0) {
                BlockState oldState = state;
                state = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true));
                worldIn.m_7731_(pos, state, 3);
                worldIn.m_7260_(pos, oldState, state, 4);
                return InteractionResult.CONSUME;
            }
            BlockState oldState = state;
            state = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
            worldIn.m_7731_(pos, state, 3);
            worldIn.m_7260_(pos, oldState, state, 4);
            player.m_5661_((Component)new TextComponent("Out of power"), true);
            return InteractionResult.CONSUME;
        }
        if (Screen.m_96637_()) {
            OpenGUIPacket openGUIPacket = new OpenGUIPacket(11, pos);
            PacketHandler.INSTANCE.sendToServer((Object)openGUIPacket);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.CONSUME;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT, FACING});
        super.m_7926_(builder);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)LIT) != false ? 15 : 0;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_())).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    public BlockColor dyeHandler() {
        return (state, world, pos, tintIndex) -> {
            if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                if (world != null && world.m_7702_(pos) instanceof TileBatteryNeon) {
                    TileBatteryNeon tileBatteryNeon = (TileBatteryNeon)world.m_7702_(pos);
                    return tileBatteryNeon.getDyeHandler().getStackInSlot(0).m_41720_() instanceof DyeItem ? ((DyeItem)tileBatteryNeon.getDyeHandler().getStackInSlot(0).m_41720_()).m_41089_().m_41070_() : DyeColor.WHITE.m_41070_();
                }
            } else {
                return DyeColor.BLACK.m_41070_();
            }
            return DyeColor.BLACK.m_41070_();
        };
    }

    @Override
    public DyeColor defaultDyeColor() {
        return DyeColor.WHITE;
    }

    public boolean removedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!world.f_46443_ && world.m_7702_(pos) instanceof TileBatteryNeon) {
            TileBatteryNeon tileBatteryNeon = (TileBatteryNeon)world.m_7702_(pos);
            tileBatteryNeon.dropInventory();
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    @Override
    public BlockState remoteSwitched(BlockState state, BlockPos pos, Level world) {
        return (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)LIT) == false));
    }

    @Override
    public boolean getPoweredState(BlockState state) {
        return (Boolean)state.m_61143_((Property)LIT);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TextComponent(ChatFormatting.YELLOW + "Dyable"));
        tooltip.add((Component)new TextComponent(ChatFormatting.GREEN + "Color: " + this.defaultDyeColor().name()));
        tooltip.add((Component)new TextComponent(ChatFormatting.BLUE + "Colored Lighting Supported"));
        super.m_5871_(stack, worldIn, tooltip, flagIn);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileBatteryNeon(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        if (level.m_5776_()) {
            return null;
        }
        return (level1, blockPos, blockState, t) -> {
            BlockEntity tile$temp = t;
            if (tile$temp instanceof TileBatteryNeon) {
                TileBatteryNeon tile = (TileBatteryNeon)tile$temp;
                tile.serverTick();
            }
        };
    }
}

