/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.blocks;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import me.hypherionmc.hyperlighting.api.DyeAble;
import me.hypherionmc.hyperlighting.api.Lightable;
import me.hypherionmc.hyperlighting.common.config.HyperLightingConfig;
import me.hypherionmc.hyperlighting.common.init.HLItems;
import me.hypherionmc.hyperlighting.common.items.BlockItemColor;
import me.hypherionmc.hyperlighting.common.tile.TileCampFire;
import me.hypherionmc.hyperlighting.util.CustomRenderType;
import me.hypherionmc.hyperlighting.util.ModUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class CampFireBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
DyeAble,
CustomRenderType,
Lightable {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.m_61587_((String)"color", DyeColor.class);
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty SIGNAL_FIRE = BlockStateProperties.f_61450_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private final boolean smokey;
    private final int fireDamage;

    public CampFireBlock(String name, DyeColor color, CreativeModeTab group) {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76370_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_60955_());
        this.smokey = true;
        this.fireDamage = 1;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)((Boolean)HyperLightingConfig.campfireOnByDefault.get()))).m_61124_((Property)SIGNAL_FIRE, (Comparable)Boolean.FALSE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(COLOR, (Comparable)color));
        if (ModUtils.isRGBLibPresent()) {
            // empty if block
        }
        HLItems.ITEMS.register(name, () -> new BlockItemColor((Block)this, new Item.Properties().m_41491_(group)));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack;
        TileCampFire TileCampFire2;
        Optional<CampfireCookingRecipe> optional;
        if (!worldIn.f_46443_ && !player.m_21120_(handIn).m_41619_() && player.m_21120_(handIn).m_41720_() instanceof DyeItem) {
            state = (BlockState)state.m_61124_(COLOR, (Comparable)((DyeItem)player.m_21120_(handIn).m_41720_()).m_41089_());
            worldIn.m_7731_(pos, state, 3);
            worldIn.m_7260_(pos, state, state, 3);
            if (!player.m_7500_()) {
                ItemStack stack = player.m_21120_(handIn);
                stack.m_41774_(1);
                player.m_21008_(handIn, stack);
            }
            return InteractionResult.CONSUME;
        }
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof TileCampFire && (optional = (TileCampFire2 = (TileCampFire)tileentity).findMatchingRecipe(itemstack = player.m_21120_(handIn))).isPresent()) {
            if (!worldIn.f_46443_ && TileCampFire2.addItem(player.m_150110_().f_35937_ ? itemstack.m_41777_() : itemstack, optional.get().m_43753_())) {
                player.m_36220_(Stats.f_12975_);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!entityIn.m_5825_() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue() && entityIn instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entityIn))) {
            entityIn.m_6469_(DamageSource.f_19305_, (float)this.fireDamage);
        }
        super.m_7892_(state, worldIn, pos, entityIn);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity instanceof TileCampFire) {
                Containers.m_19010_((Level)worldIn, (BlockPos)pos, ((TileCampFire)tileentity).getInventory());
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos;
        Level iworld = context.m_43725_();
        boolean flag = iworld.m_6425_(blockpos = context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)SIGNAL_FIRE, (Comparable)Boolean.valueOf(this.isHayBlock(iworld.m_8055_(blockpos.m_7495_()))))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(!flag))).m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_6217_().m_5945_(currentPos, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
            return Blocks.f_50016_.m_49966_();
        }
        return facing == Direction.DOWN ? (BlockState)stateIn.m_61124_((Property)SIGNAL_FIRE, (Comparable)Boolean.valueOf(this.isHayBlock(facingState))) : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private boolean isHayBlock(BlockState stateIn) {
        return stateIn.m_60713_(Blocks.f_50335_);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        if (!this.canBeLit(stateIn, worldIn, pos)) {
            CampFireBlock.extinguish((LevelAccessor)worldIn, pos, stateIn);
            worldIn.m_7260_(pos, stateIn, stateIn, 3);
        }
        if (((Boolean)stateIn.m_61143_((Property)LIT)).booleanValue()) {
            if (rand.nextInt(10) == 0) {
                worldIn.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
            }
            if (this.smokey && rand.nextInt(5) == 0) {
                for (int i = 0; i < rand.nextInt(1) + 1; ++i) {
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)(rand.nextFloat() / 2.0f), 5.0E-5, (double)(rand.nextFloat() / 2.0f));
                }
            }
        }
    }

    public static void extinguish(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockEntity tileentity;
        if (world.m_5776_() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            for (int i = 0; i < 20; ++i) {
                CampFireBlock.spawnSmokeParticles((Level)world, pos, (Boolean)state.m_61143_((Property)SIGNAL_FIRE), true);
            }
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            world.m_6289_(pos, state.m_60734_());
        }
        if ((tileentity = world.m_7702_(pos)) instanceof TileCampFire) {
            ((TileCampFire)tileentity).dropAllItems();
        }
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && fluidStateIn.m_76152_() == Fluids.f_76193_) {
            boolean flag = (Boolean)state.m_61143_((Property)LIT);
            if (flag) {
                if (!worldIn.m_5776_()) {
                    worldIn.m_5594_((Player)null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                CampFireBlock.extinguish(worldIn, pos, state);
            }
            worldIn.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            worldIn.m_6217_().m_5945_(pos, (Object)fluidStateIn.m_76152_(), fluidStateIn.m_76152_().m_6718_((LevelReader)worldIn));
            return true;
        }
        return false;
    }

    public void m_5581_(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!worldIn.f_46443_ && projectile.m_6060_()) {
            boolean flag;
            Entity entity = projectile.m_37282_();
            boolean bl = flag = entity == null || entity instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)worldIn, (Entity)entity);
            if (flag && !((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                BlockPos blockpos = hit.m_82425_();
                worldIn.m_7731_(blockpos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
            }
        }
    }

    public static void spawnSmokeParticles(Level worldIn, BlockPos pos, boolean isSignalFire, boolean spawnExtraSmoke) {
        Random random = worldIn.m_5822_();
        SimpleParticleType basicparticletype = isSignalFire ? ParticleTypes.f_123778_ : ParticleTypes.f_123777_;
        worldIn.m_6485_((ParticleOptions)basicparticletype, true, (double)pos.m_123341_() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.m_123342_() + random.nextDouble() + random.nextDouble(), (double)pos.m_123343_() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        if (spawnExtraSmoke) {
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.25 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.m_123342_() + 0.4, (double)pos.m_123343_() + 0.25 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT, SIGNAL_FIRE, WATERLOGGED, FACING, COLOR});
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public boolean canBeLit(BlockState state, Level world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false && (!world.m_46471_() || !world.m_46861_(pos));
    }

    @Override
    public BlockColor dyeHandler() {
        return (state, world, pos, tintIndex) -> {
            if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                return ((DyeColor)state.m_61143_(COLOR)).m_41070_();
            }
            return DyeColor.BLACK.m_41070_();
        };
    }

    @Override
    public DyeColor defaultDyeColor() {
        return (DyeColor)this.m_49966_().m_61143_(COLOR);
    }

    @Override
    public RenderType getRenderType() {
        return RenderType.m_110457_();
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)LIT) != false ? 15 : 0;
    }

    @Override
    public void toggleLight(Level worldIn, BlockState state, BlockPos pos) {
        state = (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)LIT) == false));
        worldIn.m_7731_(pos, state, 2);
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            CampFireBlock.extinguish((LevelAccessor)worldIn, pos, state);
        }
        worldIn.m_46672_(pos, (Block)this);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("tooltip.camp_fire"));
        tooltip.add((Component)new TranslatableComponent("tooltip.camp_fire_line1"));
        tooltip.add((Component)new TextComponent(ChatFormatting.YELLOW + "Dyable"));
        tooltip.add((Component)new TextComponent(ChatFormatting.BLUE + "Colored Lighting Supported"));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileCampFire(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return (level1, blockPos, blockState, t) -> {
            BlockEntity tile$temp = t;
            if (tile$temp instanceof TileCampFire) {
                TileCampFire tile = (TileCampFire)tile$temp;
                if (level1.m_5776_()) {
                    tile.clientTick();
                } else {
                    tile.serverTick();
                }
            }
        };
    }
}

