/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.blocks;

import javax.annotation.Nullable;
import me.hypherionmc.hyperlighting.HyperLighting;
import me.hypherionmc.hyperlighting.common.containers.ContainerSwitchBoard;
import me.hypherionmc.hyperlighting.common.init.HLItems;
import me.hypherionmc.hyperlighting.common.tile.TileSwitchBoard;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class SwitchBoard
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape BOUNDING_BOX = Block.m_49796_((double)0.0, (double)0.0, (double)12.992, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape AABB_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.008);
    private static final VoxelShape AABB_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.008, (double)16.0, (double)16.0);
    private static final VoxelShape AABB_WEST = Block.m_49796_((double)12.992, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SwitchBoard(String name) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        HLItems.ITEMS.register(name, () -> new BlockItem((Block)this, new Item.Properties().m_41491_((CreativeModeTab)HyperLighting.machinesTab)));
    }

    public InteractionResult m_6227_(BlockState state, final Level worldIn, final BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity tileEntity;
        if (!worldIn.f_46443_ && (tileEntity = worldIn.m_7702_(pos)) instanceof TileSwitchBoard) {
            MenuProvider containerProvider = new MenuProvider(){

                public Component m_5446_() {
                    return new TranslatableComponent("container.switchboard");
                }

                public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                    return new ContainerSwitchBoard(i, worldIn, pos, playerInventory, playerEntity);
                }
            };
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, (BlockPos)tileEntity.m_58899_());
        }
        return InteractionResult.CONSUME;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case EAST: {
                return AABB_EAST;
            }
            case WEST: {
                return AABB_WEST;
            }
            case SOUTH: {
                return AABB_SOUTH;
            }
        }
        return BOUNDING_BOX;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43723_().m_6350_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        super.m_7926_(builder);
    }

    public boolean removedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!world.f_46443_ && world.m_7702_(pos) instanceof TileSwitchBoard) {
            ((TileSwitchBoard)world.m_7702_(pos)).dropInventory();
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileSwitchBoard(pos, state);
    }
}

