/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.handlers;

import me.hypherionmc.hyperlighting.HyperLighting;
import me.hypherionmc.hyperlighting.api.DyeAble;
import me.hypherionmc.hyperlighting.api.ItemDyable;
import me.hypherionmc.hyperlighting.client.gui.GuiBatteryNeon;
import me.hypherionmc.hyperlighting.client.gui.GuiSwitchBoard;
import me.hypherionmc.hyperlighting.client.renderers.tile.TileCampFireRenderer;
import me.hypherionmc.hyperlighting.common.handlers.ParticleRegistryHandler;
import me.hypherionmc.hyperlighting.common.init.HLBlocks;
import me.hypherionmc.hyperlighting.common.init.HLContainers;
import me.hypherionmc.hyperlighting.common.init.HLItems;
import me.hypherionmc.hyperlighting.common.init.HLSounds;
import me.hypherionmc.hyperlighting.common.init.HLTileEntities;
import me.hypherionmc.hyperlighting.common.items.BlockItemColor;
import me.hypherionmc.hyperlighting.common.network.PacketHandler;
import me.hypherionmc.hyperlighting.util.CustomRenderType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class RegistryHandler {
    public static void init() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        HyperLighting.logger.info("Registering Blocks...");
        HLBlocks.BLOCKS.register(eventBus);
        HyperLighting.logger.info("Registering Items...");
        HLItems.ITEMS.register(eventBus);
        HyperLighting.logger.info("Registering Containers...");
        HLContainers.CONTAINERS.register(eventBus);
        ParticleRegistryHandler.PARTICLES.register(eventBus);
        HyperLighting.logger.info("Registering Tile Entities...");
        HLTileEntities.TILES.register(eventBus);
        HyperLighting.logger.info("Registering Network Packets...");
        PacketHandler.registerMessages();
        HyperLighting.logger.info("Registering Sounds...");
        HLSounds.SOUNDS.register(eventBus);
        if (ModList.get().isLoaded("theoneprobe")) {
            // empty if block
        }
    }

    public static void initClient() {
        HyperLighting.logger.info("Registering TESRs...");
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)HLTileEntities.TILE_CAMPFIRE.get()), TileCampFireRenderer::new);
        HLBlocks.BLOCKS.getEntries().forEach(blk -> {
            if (blk.get() instanceof CustomRenderType) {
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)blk.get()), (RenderType)((CustomRenderType)blk.get()).getRenderType());
            }
        });
        HyperLighting.logger.info("Registering Containers...");
        MenuScreens.m_96206_((MenuType)((MenuType)HLContainers.BATTERY_NEON_CONTAINER.get()), GuiBatteryNeon::new);
        MenuScreens.m_96206_((MenuType)((MenuType)HLContainers.SWITCHBOARD_CONTAINER.get()), GuiSwitchBoard::new);
    }

    public static void registerBlockColors() {
        BlockColors colors = Minecraft.m_91087_().m_91298_();
        HyperLighting.logger.info("Registering DyeColor handlers...");
        HLBlocks.BLOCKS.getEntries().forEach(blockRegistryObject -> {
            if (blockRegistryObject.get() instanceof DyeAble) {
                colors.m_92589_(((DyeAble)blockRegistryObject.get()).dyeHandler(), new Block[]{(Block)blockRegistryObject.get()});
            }
        });
    }

    public static void registerItemColors() {
        ItemColors itemColors = Minecraft.m_91087_().getItemColors();
        HyperLighting.logger.info("Registering Item DyeColor handlers...");
        HLItems.ITEMS.getEntries().forEach(itemRegistryObject -> {
            if (itemRegistryObject.get() instanceof BlockItemColor) {
                itemColors.m_92689_(((ItemDyable)itemRegistryObject.get()).dyeHandler(), new ItemLike[]{(ItemLike)itemRegistryObject.get()});
            }
        });
    }
}

