/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.items;

import java.util.List;
import javax.annotation.Nullable;
import me.hypherionmc.hyperlighting.HyperLighting;
import me.hypherionmc.hyperlighting.api.energy.IEnergyContainerItem;
import me.hypherionmc.hyperlighting.api.energy.ItemEnergyStorage;
import me.hypherionmc.hyperlighting.common.capabilities.CapabilityProviderEnergy;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class Battery
extends Item
implements IEnergyContainerItem {
    private final String ENERGY_TAG = "energy";
    private final int capacity;
    private final int maxReceive;
    private final int maxExtract;

    public Battery(int capacity, int maxReceive, int maxExtract) {
        super(new Item.Properties().m_41491_((CreativeModeTab)HyperLighting.machinesTab).m_41487_(1).setNoRepair());
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new CapabilityProviderEnergy(new ItemEnergyStorage(this, stack));
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (CapabilityEnergy.ENERGY == null) {
            return;
        }
        if (stack.getCapability(CapabilityEnergy.ENERGY).isPresent()) {
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY).resolve().get();
            tooltip.add((Component)new TextComponent("Energy: " + energyStorage.getEnergyStored() + "/" + energyStorage.getMaxEnergyStored()));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (!container.m_41782_()) {
            container.m_41751_(new CompoundTag());
        }
        int stored = Math.min(container.m_41783_().m_128451_("energy"), this.getMaxEnergyStored(container));
        int energyReceived = Math.min(this.capacity - stored, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.m_41783_().m_128405_("energy", stored += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.m_41783_() == null || !container.m_41783_().m_128441_("energy")) {
            return 0;
        }
        int stored = Math.min(container.m_41783_().m_128451_("energy"), this.getMaxEnergyStored(container));
        int energyExtracted = Math.min(stored, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            container.m_41783_().m_128405_("energy", stored -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        if (container.m_41783_() == null || !container.m_41783_().m_128441_("energy")) {
            return 0;
        }
        return Math.min(container.m_41783_().m_128451_("energy"), this.getMaxEnergyStored(container));
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }
}

