/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.network.packets;

import java.util.function.Supplier;
import me.hypherionmc.hyperlighting.common.containers.ContainerBatteryNeon;
import me.hypherionmc.hyperlighting.common.tile.TileBatteryNeon;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class OpenGUIPacket {
    private BlockPos posToSet;
    private int guiid;

    public OpenGUIPacket(FriendlyByteBuf buffer) {
        this.posToSet = buffer.m_130135_();
        this.guiid = buffer.readInt();
    }

    public OpenGUIPacket(int guiid, BlockPos pos) {
        this.guiid = guiid;
        this.posToSet = pos;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.posToSet);
        buf.writeInt(this.guiid);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            final BlockEntity te = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_().m_7702_(this.posToSet);
            MenuProvider containerProvider = new MenuProvider(){

                public Component m_5446_() {
                    if (te instanceof TileBatteryNeon) {
                        return new TranslatableComponent("container.batteryneon");
                    }
                    return null;
                }

                public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                    if (te instanceof TileBatteryNeon) {
                        return new ContainerBatteryNeon(i, te.m_58904_(), OpenGUIPacket.this.posToSet, playerInventory, playerEntity);
                    }
                    return null;
                }
            };
            if (containerProvider.m_5446_() != null) {
                NetworkHooks.openGui((ServerPlayer)((NetworkEvent.Context)ctx.get()).getSender(), (MenuProvider)containerProvider, (BlockPos)te.m_58899_());
            }
        });
        return true;
    }
}

