/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.hypherionmc.hyperlighting.api.SolarLight;
import me.hypherionmc.hyperlighting.api.energy.IEnergyContainerItem;
import me.hypherionmc.hyperlighting.api.energy.SolarEnergyStorage;
import me.hypherionmc.hyperlighting.common.blocks.BatteryNeon;
import me.hypherionmc.hyperlighting.common.init.HLBlocks;
import me.hypherionmc.hyperlighting.common.init.HLItems;
import me.hypherionmc.hyperlighting.common.init.HLTileEntities;
import me.hypherionmc.hyperlighting.common.tile.TileSolarPanel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;

public class TileBatteryNeon
extends BlockEntity
implements SolarLight {
    private boolean isCharging = false;
    private final SolarEnergyStorage energyStorage = new SolarEnergyStorage(500, 20, 1);
    private final ItemStackHandler itemStackHandler = new ItemHandler(1);
    private final ItemStackHandler dyeHandler = new DyeHandler(1);
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);

    public TileBatteryNeon(BlockPos pos, BlockState state) {
        super((BlockEntityType)HLTileEntities.TILE_BATTERY_NEON.get(), pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.isCharging = nbt.m_128471_("isCharging");
        this.energyStorage.readNBT(nbt);
        this.itemStackHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.dyeHandler.deserializeNBT(nbt.m_128469_("dye"));
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        super.m_6945_(compound);
        compound.m_128379_("isCharging", this.isCharging);
        this.energyStorage.writeNBT(compound);
        compound.m_128365_("inventory", (Tag)this.itemStackHandler.serializeNBT());
        compound.m_128365_("dye", (Tag)this.dyeHandler.serializeNBT());
        return compound;
    }

    @Override
    public boolean isCharging() {
        return this.isCharging;
    }

    @Override
    public int getMaxPowerLevel() {
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public int getPowerLevel() {
        return this.energyStorage.getEnergyStored();
    }

    private void sendUpdates() {
        this.f_58857_.m_6550_(this.f_58858_, this.m_58900_(), this.m_58900_());
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        this.m_6596_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 3, this.m_5995_());
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    public void serverTick() {
        if (this.f_58857_.m_46467_() % 20L == 0L) {
            if (!this.itemStackHandler.getStackInSlot(0).m_41619_() && this.itemStackHandler.getStackInSlot(0).m_41720_() == HLItems.WIRELESS_POWERCARD.get()) {
                TileSolarPanel storage1;
                BlockPos pos;
                CompoundTag tagCompound;
                ItemStack stack = this.itemStackHandler.getStackInSlot(0);
                if (stack.m_41782_() && stack.m_41783_() != null && (tagCompound = stack.m_41783_()).m_128441_("blockx") && tagCompound.m_128441_("blocky") && tagCompound.m_128441_("blockz") && this.f_58857_.m_7702_(pos = new BlockPos(tagCompound.m_128451_("blockx"), tagCompound.m_128451_("blocky"), tagCompound.m_128451_("blockz"))) != null && this.f_58857_.m_7702_(pos) instanceof TileSolarPanel && (storage1 = (TileSolarPanel)this.f_58857_.m_7702_(pos)) != null && storage1.getCapability(CapabilityEnergy.ENERGY).isPresent()) {
                    IEnergyStorage storage = (IEnergyStorage)storage1.getCapability(CapabilityEnergy.ENERGY).resolve().get();
                    if (storage.canExtract() && storage.extractEnergy(10, true) > 0) {
                        if (this.energyStorage.receiveEnergy(20, true) > 0) {
                            this.isCharging = true;
                            storage.extractEnergy(this.energyStorage.receiveEnergy(20, false), false);
                        } else {
                            this.isCharging = false;
                        }
                    } else {
                        this.isCharging = false;
                    }
                }
            } else if (!this.itemStackHandler.getStackInSlot(0).m_41619_() && this.itemStackHandler.getStackInSlot(0).m_41720_() instanceof IEnergyContainerItem) {
                IEnergyStorage storage = (IEnergyStorage)this.itemStackHandler.getStackInSlot(0).getCapability(CapabilityEnergy.ENERGY).resolve().get();
                if (storage.canExtract() && storage.extractEnergy(10, true) > 0) {
                    if (this.energyStorage.receiveEnergy(20, true) > 0) {
                        this.isCharging = true;
                        storage.extractEnergy(this.energyStorage.receiveEnergy(20, false), false);
                    } else {
                        this.isCharging = false;
                    }
                } else {
                    this.isCharging = false;
                }
            } else {
                this.isCharging = false;
            }
        }
        if (this.f_58857_.m_46467_() % 40L == 0L && this.f_58857_.m_8055_(this.f_58858_) != null && this.f_58857_.m_8055_(this.f_58858_).m_60734_() == HLBlocks.BATTERY_NEON.get() && ((Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BatteryNeon.LIT)).booleanValue()) {
            this.energyStorage.extractEnergy(1, false);
        }
        this.sendUpdates();
        this.f_58857_.m_46803_(this.f_58858_);
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    public ItemStackHandler getDyeHandler() {
        return this.dyeHandler;
    }

    public void dropInventory() {
        if (!this.dyeHandler.getStackInSlot(0).m_41619_()) {
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)this.dyeHandler.getStackInSlot(0));
        }
        if (!this.itemStackHandler.getStackInSlot(0).m_41619_()) {
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)this.itemStackHandler.getStackInSlot(0));
        }
    }

    class ItemHandler
    extends ItemStackHandler {
        public ItemHandler(int size) {
            super(size);
        }

        public void setSize(int size) {
            super.setSize(size);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.m_41720_() == HLItems.WIRELESS_POWERCARD.get();
        }
    }

    public class DyeHandler
    extends ItemStackHandler {
        public DyeHandler(int size) {
            super(size);
        }

        public void setSize(int size) {
            super.setSize(size);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.m_41720_() instanceof DyeItem;
        }
    }
}

