/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.tile;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import me.hypherionmc.hyperlighting.common.blocks.CampFireBlock;
import me.hypherionmc.hyperlighting.common.init.HLTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TileCampFire
extends BlockEntity
implements Clearable {
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    public final int[] cookingTimes = new int[4];
    public final int[] cookingTotalTimes = new int[4];

    public TileCampFire(BlockPos pos, BlockState state) {
        super((BlockEntityType)HLTileEntities.TILE_CAMPFIRE.get(), pos, state);
    }

    public void serverTick() {
        boolean flag = (Boolean)this.m_58900_().m_61143_((Property)CampFireBlock.LIT);
        if (flag) {
            this.cookAndDrop();
        } else {
            for (int i = 0; i < this.inventory.size(); ++i) {
                if (this.cookingTimes[i] <= 0) continue;
                this.cookingTimes[i] = Mth.m_14045_((int)(this.cookingTimes[i] - 2), (int)0, (int)this.cookingTotalTimes[i]);
            }
        }
    }

    public void clientTick() {
        this.addParticles();
    }

    public BlockPos m_58899_() {
        return this.f_58858_;
    }

    private void cookAndDrop() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.inventory.get(i);
            if (itemstack.m_41619_()) continue;
            int n = i;
            this.cookingTimes[n] = this.cookingTimes[n] + 1;
            if (this.cookingTimes[i] < this.cookingTotalTimes[i]) continue;
            SimpleContainer iinventory = new SimpleContainer(new ItemStack[]{itemstack});
            ItemStack itemstack1 = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44111_, (Container)iinventory, this.f_58857_).map(arg_0 -> TileCampFire.lambda$cookAndDrop$0((Container)iinventory, arg_0)).orElse(itemstack);
            BlockPos blockpos = this.m_58899_();
            Containers.m_18992_((Level)this.f_58857_, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), (ItemStack)itemstack1);
            this.inventory.set(i, (Object)ItemStack.f_41583_);
            this.inventoryChanged();
        }
    }

    private void addParticles() {
        Level world = this.m_58904_();
        if (world != null) {
            BlockPos blockpos = this.m_58899_();
            Random random = world.f_46441_;
            if (random.nextFloat() < 0.11f) {
                for (int i = 0; i < random.nextInt(2) + 2; ++i) {
                    CampFireBlock.spawnSmokeParticles(world, blockpos, (Boolean)this.m_58900_().m_61143_((Property)CampFireBlock.SIGNAL_FIRE), false);
                }
            }
            int l = ((Direction)this.m_58900_().m_61143_((Property)CampFireBlock.FACING)).m_122416_();
            for (int j = 0; j < this.inventory.size(); ++j) {
                if (((ItemStack)this.inventory.get(j)).m_41619_() || !(random.nextFloat() < 0.2f)) continue;
                Direction direction = Direction.m_122407_((int)Math.floorMod(j + l, 4));
                float f = 0.3125f;
                double d0 = (double)blockpos.m_123341_() + 0.5 - (double)((float)direction.m_122429_() * 0.3125f) + (double)((float)direction.m_122427_().m_122429_() * 0.3125f);
                double d1 = (double)blockpos.m_123342_() + 0.5;
                double d2 = (double)blockpos.m_123343_() + 0.5 - (double)((float)direction.m_122431_() * 0.3125f) + (double)((float)direction.m_122427_().m_122431_() * 0.3125f);
                for (int k = 0; k < 4; ++k) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 5.0E-4, 0.0);
                }
            }
        }
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory.clear();
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        if (nbt.m_128425_("CookingTimes", 11)) {
            int[] aint = nbt.m_128465_("CookingTimes");
            System.arraycopy(aint, 0, this.cookingTimes, 0, Math.min(this.cookingTotalTimes.length, aint.length));
        }
        if (nbt.m_128425_("CookingTotalTimes", 11)) {
            int[] aint1 = nbt.m_128465_("CookingTotalTimes");
            System.arraycopy(aint1, 0, this.cookingTotalTimes, 0, Math.min(this.cookingTotalTimes.length, aint1.length));
        }
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        this.writeItems(compound);
        compound.m_128385_("CookingTimes", this.cookingTimes);
        compound.m_128385_("CookingTotalTimes", this.cookingTotalTimes);
        return compound;
    }

    private CompoundTag writeItems(CompoundTag compound) {
        super.m_6945_(compound);
        ContainerHelper.m_18976_((CompoundTag)compound, this.inventory, (boolean)true);
        return compound;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 13, this.m_5995_());
    }

    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    public Optional<CampfireCookingRecipe> findMatchingRecipe(ItemStack itemStackIn) {
        return this.inventory.stream().noneMatch(ItemStack::m_41619_) ? Optional.empty() : this.f_58857_.m_7465_().m_44015_(RecipeType.f_44111_, (Container)new SimpleContainer(new ItemStack[]{itemStackIn}), this.f_58857_);
    }

    public boolean addItem(ItemStack itemStackIn, int cookTime) {
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.inventory.get(i);
            if (!itemstack.m_41619_()) continue;
            this.cookingTotalTimes[i] = cookTime;
            this.cookingTimes[i] = 0;
            this.inventory.set(i, (Object)itemStackIn.m_41620_(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    private void inventoryChanged() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    public void dropAllItems() {
        if (this.f_58857_ != null) {
            if (!this.f_58857_.f_46443_) {
                Containers.m_19010_((Level)this.f_58857_, (BlockPos)this.m_58899_(), this.getInventory());
            }
            this.inventoryChanged();
        }
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
    }

    public CompoundTag serializeNBT() {
        return super.serializeNBT();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public void onLoad() {
        super.onLoad();
    }

    private static /* synthetic */ ItemStack lambda$cookAndDrop$0(Container iinventory, CampfireCookingRecipe campfireRecipe) {
        return campfireRecipe.m_5874_(iinventory);
    }
}

