/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.hypherionmc.hyperlighting.api.SolarLight;
import me.hypherionmc.hyperlighting.api.energy.SolarEnergyStorage;
import me.hypherionmc.hyperlighting.common.blocks.FenceSolar;
import me.hypherionmc.hyperlighting.common.init.HLTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileSolarLight
extends BlockEntity
implements SolarLight {
    private int powerLevel = 0;
    private boolean isCharging = false;
    private final int maxPowerLevel = 500;
    private final SolarEnergyStorage energyStorage = new SolarEnergyStorage(500, 100, 0);
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);

    public TileSolarLight(BlockPos pos, BlockState state) {
        super((BlockEntityType)HLTileEntities.TILE_SOLAR_LIGHT.get(), pos, state);
    }

    public void serverTick() {
        Block blockType;
        if (this.f_58857_ != null && this.f_58857_.m_46467_() % 20L == 0L && (blockType = this.m_58900_().m_60734_()) instanceof FenceSolar) {
            BlockState iblockstate;
            BlockState oldState = iblockstate = this.f_58857_.m_8055_(this.f_58858_);
            if (this.f_58857_.m_6042_().m_63935_()) {
                int i = this.f_58857_.m_45517_(LightLayer.SKY, this.f_58858_) - this.f_58857_.m_7445_();
                float f = this.f_58857_.m_46490_(1.0f);
                if (i > 5 && this.powerLevel < this.maxPowerLevel) {
                    float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
                    f += (f1 - f) * 0.2f;
                    i = Math.round((float)i * Mth.m_14089_((float)f));
                    i = Mth.m_14045_((int)i, (int)0, (int)15);
                    this.isCharging = true;
                    this.powerLevel += i;
                } else {
                    this.isCharging = false;
                }
                if (this.powerLevel > this.maxPowerLevel) {
                    this.powerLevel = this.maxPowerLevel;
                }
                if (this.powerLevel < 1) {
                    this.powerLevel = 0;
                }
                if (((Boolean)iblockstate.m_61143_((Property)FenceSolar.LIT)).booleanValue()) {
                    if (this.powerLevel < 1) {
                        iblockstate = (BlockState)iblockstate.m_61124_((Property)FenceSolar.LIT, (Comparable)Boolean.valueOf(false));
                        this.f_58857_.m_7731_(this.f_58858_, iblockstate, 3);
                        this.f_58857_.m_7260_(this.f_58858_, oldState, iblockstate, 4);
                    } else {
                        --this.powerLevel;
                    }
                }
            }
            this.sendUpdates();
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.powerLevel = compound.m_128451_("power");
        this.isCharging = compound.m_128471_("isCharging");
        this.energyStorage.readNBT(compound.m_128469_("energyStorage"));
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        super.m_6945_(compound);
        compound.m_128405_("power", this.powerLevel);
        compound.m_128379_("isCharging", this.isCharging);
        compound.m_128365_("energyStorage", (Tag)this.energyStorage.writeNBT(compound));
        return compound;
    }

    @Override
    public boolean isCharging() {
        return this.isCharging;
    }

    @Override
    public int getMaxPowerLevel() {
        return this.maxPowerLevel;
    }

    @Override
    public int getPowerLevel() {
        return this.powerLevel;
    }

    private void sendUpdates() {
        this.f_58857_.m_6550_(this.f_58858_, this.m_58900_(), this.m_58900_());
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        this.m_6596_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 3, this.m_5995_());
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }
}

