/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.tile;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.hypherionmc.hyperlighting.api.energy.SolarEnergyStorage;
import me.hypherionmc.hyperlighting.common.blocks.SolarPanel;
import me.hypherionmc.hyperlighting.common.init.HLTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileSolarPanel
extends BlockEntity {
    private final SolarEnergyStorage energyStorage = new SolarEnergyStorage(2000, 0, 1000);
    private LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);

    public TileSolarPanel(BlockPos pos, BlockState state) {
        super((BlockEntityType)HLTileEntities.TILE_SOLAR_PANEL.get(), pos, state);
    }

    public void serverTick() {
        Block blockType = this.m_58900_().m_60734_();
        if (blockType instanceof SolarPanel) {
            if (this.f_58857_.m_6042_().m_63935_()) {
                int i = this.f_58857_.m_45517_(LightLayer.SKY, this.f_58858_) - this.f_58857_.m_7445_();
                float f = this.f_58857_.m_46490_(1.0f);
                if (i > 5 && this.energyStorage.getEnergyStored() < this.energyStorage.getMaxEnergyStored()) {
                    float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
                    f += (f1 - f) * 0.2f;
                    i = Math.round((float)i * Mth.m_14089_((float)f));
                    i = Mth.m_14045_((int)i, (int)0, (int)15);
                    this.energyStorage.receiveEnergyInternal(i, false);
                }
            }
            for (Direction direction : Direction.values()) {
                IEnergyStorage storage;
                direction = direction.m_122424_();
                if (this.f_58857_.m_7702_(this.m_58899_().m_142300_(direction)) == null || !this.f_58857_.m_7702_(this.m_58899_().m_142300_(direction)).getCapability(CapabilityEnergy.ENERGY).isPresent() || !(storage = (IEnergyStorage)this.f_58857_.m_7702_(this.m_58899_().m_142300_(direction)).getCapability(CapabilityEnergy.ENERGY).resolve().get()).canReceive() || storage.receiveEnergy(200, true) <= 0 || this.energyStorage.extractEnergy(200, true) <= 0) continue;
                storage.receiveEnergy(this.energyStorage.extractEnergy(200, false), false);
            }
            this.sendUpdates();
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.energyStorage.readNBT(compound);
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        super.m_6945_(compound);
        this.energyStorage.writeNBT(compound);
        return compound;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 3, this.m_5995_());
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    private void sendUpdates() {
        this.f_58857_.m_6550_(this.f_58858_, this.m_58900_(), this.m_58900_());
        this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        this.m_6596_();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    void transferEnergyToAllAround() {
        if (!this.canTransferEnergyToAllAround()) {
            return;
        }
        this.getConnectedSides().forEach(side -> this.transferEnergyTo((Direction)side, (int)((float)this.energyStorage.getEnergyStored() / (float)this.getConnectedSides().size()), false));
    }

    boolean canTransferEnergyToAllAround() {
        if (this.m_58904_().f_46443_) {
            return false;
        }
        if (!this.energyStorage.canExtract()) {
            return false;
        }
        return this.energyStorage.getEnergyStored() > 0;
    }

    ArrayList<Direction> getConnectedSides() {
        ArrayList<Direction> connectedSides = new ArrayList<Direction>();
        for (Direction side : Direction.values()) {
            if (!this.isConnectedTo(side)) continue;
            connectedSides.add(side);
        }
        return connectedSides;
    }

    int transferEnergyTo(Direction side, int energyToTransfer, boolean simulate) {
        if (!this.canTransferEnergyTo(side, energyToTransfer)) {
            return 0;
        }
        IEnergyStorage storage = (IEnergyStorage)this.m_58904_().m_7702_(this.m_58899_().m_142300_(side)).getCapability(CapabilityEnergy.ENERGY, side.m_122424_()).resolve().get();
        return this.energyStorage.extractEnergy(storage.receiveEnergy(energyToTransfer, simulate), simulate);
    }

    boolean canTransferEnergyTo(Direction side, int energyToTransfer) {
        if (!this.energyStorage.canExtract()) {
            return false;
        }
        if (this.m_58904_() == null) {
            return false;
        }
        if (this.m_58904_().f_46443_) {
            return false;
        }
        if (this.m_58904_().m_7702_(this.m_58899_().m_142300_(side)) == null) {
            return false;
        }
        IEnergyStorage storage = (IEnergyStorage)this.m_58904_().m_7702_(this.m_58899_().m_142300_(side)).getCapability(CapabilityEnergy.ENERGY, side.m_122424_()).resolve().get();
        if (storage == null) {
            return false;
        }
        return storage.canReceive();
    }

    boolean isConnectedTo(Direction side) {
        if (this.m_58904_() == null) {
            return false;
        }
        BlockEntity tile = this.m_58904_().m_7702_(this.m_58899_().m_142300_(side));
        if (tile == null) {
            return false;
        }
        return tile.getCapability(CapabilityEnergy.ENERGY, side.m_122424_()) != null;
    }
}

