/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.hyperlighting.common.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.hypherionmc.hyperlighting.api.RemoteSwitchable;
import me.hypherionmc.hyperlighting.api.SolarLight;
import me.hypherionmc.hyperlighting.api.SwitchModule;
import me.hypherionmc.hyperlighting.common.init.HLTileEntities;
import me.hypherionmc.hyperlighting.common.network.PacketHandler;
import me.hypherionmc.hyperlighting.common.network.packets.PacketStateToggle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileSwitchBoard
extends BlockEntity {
    private final ItemStackHandler itemStackHandler = new SwitchItemStackHandler(6);
    private LazyOptional<IItemHandler> storage = LazyOptional.of(() -> this.itemStackHandler);

    public TileSwitchBoard(BlockPos pos, BlockState state) {
        super((BlockEntityType)HLTileEntities.TILE_SWITCHBOARD.get(), pos, state);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.storage.cast();
        }
        return super.getCapability(cap, side);
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        super.m_6945_(compound);
        compound.m_128365_("inventory", (Tag)this.itemStackHandler.serializeNBT());
        return compound;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.itemStackHandler.deserializeNBT(compound.m_128469_("inventory"));
    }

    public int getPowerLevel(int SlotID) {
        ItemStack stack = this.itemStackHandler.getStackInSlot(SlotID);
        if (this.isLinked(SlotID)) {
            CompoundTag compound = stack.m_41783_();
            BlockPos pos = new BlockPos(compound.m_128451_("blockx"), compound.m_128451_("blocky"), compound.m_128451_("blockz"));
            SolarLight solar = (SolarLight)this.f_58857_.m_7702_(pos);
            return (int)((double)solar.getPowerLevel() / (double)solar.getMaxPowerLevel() * 23.0);
        }
        return 0;
    }

    public int getPowerLevelPer(int SlotID) {
        ItemStack stack = this.itemStackHandler.getStackInSlot(SlotID);
        if (this.isLinked(SlotID)) {
            CompoundTag compound = stack.m_41783_();
            BlockPos pos = new BlockPos(compound.m_128451_("blockx"), compound.m_128451_("blocky"), compound.m_128451_("blockz"));
            SolarLight solar = (SolarLight)this.f_58857_.m_7702_(pos);
            return (int)((double)solar.getPowerLevel() / (double)solar.getMaxPowerLevel() * 100.0);
        }
        return 0;
    }

    public boolean getState(int SlotID) {
        CompoundTag compound;
        BlockPos pos;
        ItemStack stack = this.itemStackHandler.getStackInSlot(SlotID);
        if (this.isLinked(SlotID) && this.f_58857_.m_8055_(pos = new BlockPos((compound = stack.m_41783_()).m_128451_("blockx"), compound.m_128451_("blocky"), compound.m_128451_("blockz"))).m_60734_() instanceof RemoteSwitchable) {
            return ((RemoteSwitchable)this.f_58857_.m_8055_(pos).m_60734_()).getPoweredState(this.f_58857_.m_8055_(pos));
        }
        return false;
    }

    public boolean getCharging(int SlotID) {
        ItemStack stack = this.itemStackHandler.getStackInSlot(SlotID);
        if (this.isLinked(SlotID)) {
            CompoundTag compound = stack.m_41783_();
            BlockPos pos = new BlockPos(compound.m_128451_("blockx"), compound.m_128451_("blocky"), compound.m_128451_("blockz"));
            SolarLight solar = (SolarLight)this.f_58857_.m_7702_(pos);
            return solar.isCharging();
        }
        return false;
    }

    public boolean isLinked(int SlotID) {
        BlockPos pos;
        CompoundTag compound;
        ItemStack stack = this.itemStackHandler.getStackInSlot(SlotID);
        return !stack.m_41619_() && stack.m_41720_() instanceof SwitchModule && stack.m_41783_() != null && (compound = stack.m_41783_()).m_128441_("blockx") && compound.m_128441_("blocky") && compound.m_128441_("blockz") && this.f_58857_.m_7702_(pos = new BlockPos(compound.m_128451_("blockx"), compound.m_128451_("blocky"), compound.m_128451_("blockz"))) != null && this.f_58857_.m_7702_(pos).m_58898_() && this.f_58857_.m_7702_(pos) instanceof SolarLight;
    }

    public void toggleState(int SlotID) {
        ItemStack stack = this.itemStackHandler.getStackInSlot(SlotID);
        if (this.isLinked(SlotID)) {
            CompoundTag compound = stack.m_41783_();
            BlockPos pos = new BlockPos(compound.m_128451_("blockx"), compound.m_128451_("blocky"), compound.m_128451_("blockz"));
            PacketStateToggle msg = new PacketStateToggle(pos);
            if (this.getPowerLevel(SlotID) > 0) {
                PacketHandler.INSTANCE.sendToServer((Object)msg);
            } else if (this.f_58857_.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 1.0, false) != null) {
                this.f_58857_.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 1.0, false).m_5661_((Component)new TranslatableComponent("Out of power"), true);
            }
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 3, this.m_5995_());
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    public void dropInventory() {
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            if (this.itemStackHandler.getStackInSlot(i).m_41619_()) continue;
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)this.itemStackHandler.getStackInSlot(i));
        }
    }

    public static class SwitchItemStackHandler
    extends ItemStackHandler {
        public SwitchItemStackHandler(int size) {
            super(size);
        }

        public void setSize(int size) {
            super.setSize(size);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.m_41720_() instanceof SwitchModule;
        }
    }
}

