/*
 * Decompiled with CFR 0.152.
 */
package space.essem.image2map;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import me.sargunvohra.mcmods.autoconfig1u.AutoConfig;
import me.sargunvohra.mcmods.autoconfig1u.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3222;
import space.essem.image2map.config.Image2MapConfig;
import space.essem.image2map.renderer.MapRenderer;

public class Image2Map
implements ModInitializer {
    public static Image2MapConfig CONFIG = (Image2MapConfig)AutoConfig.register(Image2MapConfig.class, GsonConfigSerializer::new).getConfig();

    public void onInitialize() {
        System.out.println("Loading Image2Map...");
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mapcreate").requires(source -> source.method_9259(Image2Map.CONFIG.minPermLevel))).then(class_2170.method_9244((String)"path", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            BufferedImage image;
            class_2168 source = (class_2168)context.getSource();
            class_243 pos = source.method_9222();
            class_3222 player = source.method_9207();
            String input = StringArgumentType.getString((CommandContext)context, (String)"path");
            source.method_9226((class_2561)new class_2585("Generating image map..."), false);
            try {
                if (Image2Map.isValid(input)) {
                    URL url = new URL(input);
                    URLConnection connection = url.openConnection();
                    connection.setRequestProperty("User-Agent", "Image2Map mod");
                    connection.connect();
                    image = ImageIO.read(connection.getInputStream());
                } else if (Image2Map.CONFIG.allowLocalFiles) {
                    File file = new File(input);
                    image = ImageIO.read(file);
                } else {
                    image = null;
                }
            }
            catch (IOException e) {
                source.method_9226((class_2561)new class_2585("That doesn't seem to be a valid image."), false);
                return 0;
            }
            if (image == null) {
                source.method_9226((class_2561)new class_2585("That doesn't seem to be a valid image."), false);
                return 0;
            }
            class_1799 stack = MapRenderer.render(image, source.method_9225(), pos.field_1352, pos.field_1350, (class_1657)player);
            source.method_9226((class_2561)new class_2585("Done!"), false);
            if (!player.field_7514.method_7394(stack)) {
                class_1542 itemEntity = new class_1542(player.field_6002, player.method_19538().field_1352, player.method_19538().field_1351, player.method_19538().field_1350, stack);
                player.field_6002.method_8649((class_1297)itemEntity);
            }
            return 1;
        }))));
    }

    private static boolean isValid(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

