/*
 * Decompiled with CFR 0.152.
 */
package space.essem.image2map.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.Arrays;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_3218;
import net.minecraft.class_3620;

public class MapRenderer {
    private static final double[] shadeCoeffs = new double[]{0.71, 0.86, 1.0, 0.53};

    private static double distance(double[] vectorA, double[] vectorB) {
        return Math.sqrt(Math.pow(vectorA[0] - vectorB[0], 2.0) + Math.pow(vectorA[1] - vectorB[1], 2.0) + Math.pow(vectorA[2] - vectorB[2], 2.0));
    }

    private static double[] applyShade(double[] color, int ind) {
        double coeff = shadeCoeffs[ind];
        return new double[]{color[0] * coeff, color[1] * coeff, color[2] * coeff};
    }

    public static class_1799 render(BufferedImage image, class_3218 world, double x, double z, class_1657 player) {
        class_1799 stack = class_1806.method_8005((class_1937)world, (int)((int)x), (int)((int)z), (byte)3, (boolean)false, (boolean)false);
        class_22 state = class_1806.method_7997((class_1799)stack, (class_1937)world);
        state.field_17403 = true;
        Image resizedImage = image.getScaledInstance(128, 128, 1);
        BufferedImage resized = MapRenderer.convertToBufferedImage(resizedImage);
        int width = resized.getWidth();
        int height = resized.getHeight();
        int[][] pixels = MapRenderer.convertPixelArray(resized);
        class_3620[] colors = class_3620.field_16006;
        colors = (class_3620[])Arrays.stream(colors).filter(s -> s != null).toArray(class_3620[]::new);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                Color imageColor = new Color(pixels[j][i], true);
                double[] imageVec = new double[]{(double)imageColor.getRed() / 255.0, (double)imageColor.getGreen() / 255.0, (double)imageColor.getBlue() / 255.0};
                int best_color = 0;
                double lowest_distance = 10000.0;
                for (int k = 0; k < colors.length; ++k) {
                    Color mcColor = new Color(colors[k].field_16011);
                    double[] mcColorVec = new double[]{(double)mcColor.getRed() / 255.0, (double)mcColor.getGreen() / 255.0, (double)mcColor.getBlue() / 255.0};
                    for (int shadeInd = 0; shadeInd < shadeCoeffs.length; ++shadeInd) {
                        double distance = MapRenderer.distance(imageVec, MapRenderer.applyShade(mcColorVec, shadeInd));
                        if (!(distance < lowest_distance)) continue;
                        lowest_distance = distance;
                        best_color = k == 0 && imageColor.getAlpha() == 255 ? 119 : k * shadeCoeffs.length + shadeInd;
                    }
                }
                state.field_122[i + j * width] = (byte)best_color;
            }
        }
        return stack;
    }

    private static int[][] convertPixelArray(BufferedImage image) {
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] result = new int[height][width];
        int pixelLength = 4;
        int pixel = 0;
        int row = 0;
        int col = 0;
        while (pixel + 3 < pixels.length) {
            int argb = 0;
            argb += (pixels[pixel] & 0xFF) << 24;
            argb += pixels[pixel + 1] & 0xFF;
            argb += (pixels[pixel + 2] & 0xFF) << 8;
            result[row][col] = argb += (pixels[pixel + 3] & 0xFF) << 16;
            if (++col == width) {
                col = 0;
                ++row;
            }
            pixel += 4;
        }
        return result;
    }

    private static BufferedImage convertToBufferedImage(Image image) {
        BufferedImage newImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 6);
        Graphics2D g = newImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return newImage;
    }
}

