/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp;

import com.mojang.brigadier.CommandDispatcher;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.command.CommandSource;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.infernalstudios.infernalexp.client.InfernalExpansionClient;
import org.infernalstudios.infernalexp.config.ConfigHelper;
import org.infernalstudios.infernalexp.config.ConfigHolder;
import org.infernalstudios.infernalexp.data.SpawnrateManager;
import org.infernalstudios.infernalexp.events.MiscEvents;
import org.infernalstudios.infernalexp.events.MobEvents;
import org.infernalstudios.infernalexp.events.WorldEvents;
import org.infernalstudios.infernalexp.init.IEBiomes;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.init.IEBrewingRecipes;
import org.infernalstudios.infernalexp.init.IECapabilities;
import org.infernalstudios.infernalexp.init.IECommands;
import org.infernalstudios.infernalexp.init.IECompostables;
import org.infernalstudios.infernalexp.init.IEEffects;
import org.infernalstudios.infernalexp.init.IEEntityClassifications;
import org.infernalstudios.infernalexp.init.IEEntityTypes;
import org.infernalstudios.infernalexp.init.IEItems;
import org.infernalstudios.infernalexp.init.IELootModifiers;
import org.infernalstudios.infernalexp.init.IEPaintings;
import org.infernalstudios.infernalexp.init.IEParticleTypes;
import org.infernalstudios.infernalexp.init.IEPotions;
import org.infernalstudios.infernalexp.init.IEProcessors;
import org.infernalstudios.infernalexp.init.IEShroomloinTypes;
import org.infernalstudios.infernalexp.init.IESoundEvents;
import org.infernalstudios.infernalexp.init.IEStructures;
import org.infernalstudios.infernalexp.init.IETileEntityTypes;
import org.infernalstudios.infernalexp.items.IESpawnEggItem;
import org.infernalstudios.infernalexp.mixin.common.WorldCarverAccessor;
import org.infernalstudios.infernalexp.network.IENetworkHandler;
import org.infernalstudios.infernalexp.util.CompatibilityQuark;
import org.infernalstudios.infernalexp.world.dimension.ModNetherBiomeProvider;
import org.infernalstudios.infernalexp.world.gen.ModEntityPlacement;

@Mod(value="infernalexp")
public class InfernalExpansion {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "infernalexp";
    public static final ItemGroup TAB = new ItemGroup("InfernalTab"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)IEItems.TAB_ITEM.get());
        }
    };

    public InfernalExpansion() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::commonSetup);
        IEParticleTypes.PARTICLES.register(modEventBus);
        IESoundEvents.register(modEventBus);
        IEBlocks.register(modEventBus);
        IEItems.register(modEventBus);
        IEEffects.register(modEventBus);
        IEPotions.register(modEventBus);
        IEEntityTypes.register(modEventBus);
        IEPaintings.register(modEventBus);
        IETileEntityTypes.register(modEventBus);
        IEBiomes.register(modEventBus);
        IELootModifiers.register(modEventBus);
        IEShroomloinTypes.registerAll();
        IEEntityClassifications.register();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new MiscEvents());
        MinecraftForge.EVENT_BUS.register((Object)new MobEvents());
        MinecraftForge.EVENT_BUS.register((Object)new WorldEvents());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(ModNetherBiomeProvider::registerBiomeProvider);
        event.enqueueWork(IEProcessors::registerProcessors);
        event.enqueueWork(IEStructures::setupStructures);
        event.enqueueWork(IENetworkHandler::register);
        event.enqueueWork(IECapabilities::registerCapabilities);
        event.enqueueWork(IEBrewingRecipes::register);
        event.enqueueWork(SpawnrateManager::createResources);
        event.enqueueWork(() -> {
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ConfigHolder.CLIENT_SPEC);
            ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigHolder.COMMON_SPEC);
            ConfigHelper.bakeClient(null);
            ConfigHelper.bakeCommon(null);
        });
        event.enqueueWork(() -> {
            Set newCarvableBlocks = Stream.of((Block)IEBlocks.DULLSTONE.get(), (Block)IEBlocks.DIMSTONE.get(), Blocks.field_150426_aN, (Block)IEBlocks.GLOWDUST_SAND.get(), (Block)IEBlocks.GLOWDUST.get()).collect(Collectors.toCollection(HashSet::new));
            newCarvableBlocks.addAll(((WorldCarverAccessor)WorldCarver.field_236240_b_).getCarvableBlocks());
            ((WorldCarverAccessor)WorldCarver.field_236240_b_).setCarvableBlocks(newCarvableBlocks);
        });
        CraftingHelper.register((IConditionSerializer)new CompatibilityQuark.Serializer());
        ModEntityPlacement.spawnPlacement();
        FlowerPotBlock flowerPot = (FlowerPotBlock)Blocks.field_150457_bL;
        flowerPot.addPlant(IEBlocks.DULLTHORNS.getId(), IEBlocks.POTTED_DULLTHORNS);
        flowerPot.addPlant(IEBlocks.LUMINOUS_FUNGUS.getId(), IEBlocks.POTTED_LUMINOUS_FUNGUS);
        flowerPot.addPlant(IEBlocks.SHROOMLIGHT_FUNGUS.getId(), IEBlocks.POTTED_SHROOMLIGHT_FUNGUS);
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151114_aO, (IDispenseItemBehavior)new DefaultDispenseItemBehavior(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                ServerWorld world = source.func_197524_h();
                BlockPos blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
                ItemStack itemstack = stack.func_77979_a(1);
                if (world.func_180495_p(blockpos).func_177230_c() == IEBlocks.DIMSTONE.get()) {
                    world.func_175656_a(blockpos, Blocks.field_150426_aN.func_176223_P());
                } else if (world.func_180495_p(blockpos).func_177230_c() == IEBlocks.DULLSTONE.get()) {
                    world.func_175656_a(blockpos, ((Block)IEBlocks.DIMSTONE.get()).func_176223_P());
                } else {
                    1.func_82486_a((World)world, (ItemStack)itemstack, (int)6, (Direction)((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a)), (IPosition)DispenserBlock.func_149939_a((IBlockSource)source));
                }
                return stack;
            }
        });
        IECompostables.registerCompostables();
        IESpawnEggItem.initUnaddedEggs();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> InfernalExpansionClient::init);
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        IECommands.registerCommands((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
    }
}

