/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.access;

import com.google.common.base.Supplier;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.util.ResourceLocation;
import org.infernalstudios.infernalexp.client.ClientFireType;

public interface FireTypeAccess {
    public static final RenderMaterial LOCATION_SOUL_FIRE_0 = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("block/soul_fire_0"));
    public static final RenderMaterial LOCATION_SOUL_FIRE_1 = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("block/soul_fire_1"));
    public static final RenderMaterial LOCATION_GLOW_FIRE_0 = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("infernalexp", "block/glow_fire_0"));
    public static final RenderMaterial LOCATION_GLOW_FIRE_1 = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("infernalexp", "block/glow_fire_1"));
    public static final RenderMaterial LOCATION_ENDER_FIRE_0 = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("endergetic", "block/ender_fire_0"));
    public static final RenderMaterial LOCATION_ENDER_FIRE_1 = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("endergetic", "block/ender_fire_1"));
    public static final RenderMaterial LOCATION_BORIC_FIRE_0 = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("byg", "block/boric_fire_0"));
    public static final RenderMaterial LOCATION_BORIC_FIRE_1 = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("byg", "block/boric_fire_1"));
    public static final RenderMaterial LOCATION_CRYPTIC_FIRE_0 = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("byg", "block/cryptic_fire_0"));
    public static final RenderMaterial LOCATION_CRYPTIC_FIRE_1 = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("byg", "block/cryptic_fire_1"));

    public KnownFireTypes getFireType();

    public void setFireType(KnownFireTypes var1);

    public static enum KnownFireTypes {
        FIRE("fire", (Supplier<ClientFireType>)((Supplier)() -> new ClientFireType(ModelBakery.field_207763_a, ModelBakery.field_207764_b))),
        SOUL_FIRE("soul_fire", (Supplier<ClientFireType>)((Supplier)() -> new ClientFireType(LOCATION_SOUL_FIRE_0, LOCATION_SOUL_FIRE_1))),
        GLOW_FIRE("glow_fire", (Supplier<ClientFireType>)((Supplier)() -> new ClientFireType(LOCATION_GLOW_FIRE_0, LOCATION_GLOW_FIRE_1))),
        ENDER_FIRE("ender_fire", (Supplier<ClientFireType>)((Supplier)() -> new ClientFireType(LOCATION_ENDER_FIRE_0, LOCATION_ENDER_FIRE_1))),
        BORIC_FIRE("boric_fire", (Supplier<ClientFireType>)((Supplier)() -> new ClientFireType(LOCATION_BORIC_FIRE_0, LOCATION_BORIC_FIRE_1))),
        CRYPTIC_FIRE("cryptic_fire", (Supplier<ClientFireType>)((Supplier)() -> new ClientFireType(LOCATION_CRYPTIC_FIRE_0, LOCATION_CRYPTIC_FIRE_1)));

        public static final KnownFireTypes[] VALUES;
        public static final Map<String, KnownFireTypes> NAME_LOOKUP;
        private final String name;
        private final Supplier<ClientFireType> supplier;

        private KnownFireTypes(String name, Supplier<ClientFireType> supplier) {
            this.name = name;
            this.supplier = supplier;
        }

        public String toString() {
            return this.getName();
        }

        public String getName() {
            return this.name;
        }

        public Supplier<ClientFireType> getSupplier() {
            return this.supplier;
        }

        @Nullable
        public static KnownFireTypes byName(String name) {
            return name.equals("") ? FIRE : NAME_LOOKUP.get(name.toLowerCase(Locale.ROOT));
        }

        static {
            VALUES = KnownFireTypes.values();
            NAME_LOOKUP = Arrays.stream(VALUES).collect(Collectors.toMap(KnownFireTypes::getName, fireType -> fireType));
        }
    }
}

