/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.blocks;

import javax.annotation.CheckForNull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.infernalstudios.infernalexp.blocks.HorizontalBushBlock;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.init.IETags;

public class BuriedBoneBlock
extends HorizontalBushBlock {
    protected static final VoxelShape FLOOR_SHAPE = BuriedBoneBlock.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    protected static final VoxelShape CEILING_SHAPE = BuriedBoneBlock.func_208617_a((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public BuriedBoneBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)field_196366_M, (Comparable)AttachFace.FLOOR));
    }

    @CheckForNull
    public BlockState getPlaceableState(World world, BlockPos pos, Direction placeSide) {
        if (world.func_180495_p(pos).func_185904_a().func_76222_j() && world.func_180495_p(pos).func_177230_c() != IEBlocks.BURIED_BONE.get()) {
            Direction attachdirection;
            if (placeSide.func_176740_k() != Direction.Axis.Y) {
                placeSide = Direction.UP;
            }
            if (this.isValidGround(world.func_180495_p(pos.func_177972_a(placeSide.func_176734_d())), (IBlockReader)world, pos)) {
                attachdirection = placeSide.func_176734_d();
            } else if (this.isValidGround(world.func_180495_p(pos.func_177972_a(placeSide)), (IBlockReader)world, pos)) {
                attachdirection = placeSide;
            } else {
                return null;
            }
            AttachFace attachface = attachdirection == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR;
            return (BlockState)this.func_176223_P().func_206870_a((Property)field_196366_M, (Comparable)attachface);
        }
        return null;
    }

    @Override
    protected boolean isValidGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_177230_c().func_203417_a(IETags.Blocks.BURIED_BONE_BASE_BLOCKS);
    }

    public boolean canAttach(IWorldReader reader, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.func_177972_a(direction);
        return this.isValidGround(reader.func_180495_p(blockpos), (IBlockReader)reader, blockpos);
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return !((AttachFace)state.func_177229_b((Property)field_196366_M)).equals((Object)AttachFace.WALL) && this.canAttach(worldIn, pos, BuriedBoneBlock.func_196365_i((BlockState)state).func_176734_d());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Vector3d vector3d = state.func_191059_e(worldIn, pos);
        switch ((AttachFace)state.func_177229_b((Property)field_196366_M)) {
            case FLOOR: {
                return FLOOR_SHAPE.func_197751_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
            }
        }
        return CEILING_SHAPE.func_197751_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builderIn) {
        builderIn.func_206894_a(new Property[]{field_185512_D, field_196366_M});
    }

    public Item func_199767_j() {
        return Items.field_151103_aS;
    }
}

