/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.HugeFungusConfig;
import net.minecraft.world.server.ServerWorld;
import org.infernalstudios.infernalexp.blocks.HorizontalBushBlock;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.init.IEConfiguredFeatures;
import org.infernalstudios.infernalexp.init.IEEffects;
import org.infernalstudios.infernalexp.tileentities.LuminousFungusTileEntity;

public class LuminousFungusBlock
extends HorizontalBushBlock
implements IGrowable {
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    protected static final VoxelShape FLOOR_SHAPE = LuminousFungusBlock.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    protected static final VoxelShape CEILING_SHAPE = LuminousFungusBlock.func_208617_a((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public LuminousFungusBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_196366_M, (Comparable)AttachFace.FLOOR)).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    protected boolean isValidGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_203425_a((Block)IEBlocks.GLOWDUST_SAND.get()) || state.func_203425_a(Blocks.field_150354_m) || state.func_203425_a(Blocks.field_196611_F) || state.func_203425_a(Blocks.field_150349_c) || state.func_203425_a(Blocks.field_196658_i) || state.func_203425_a(Blocks.field_150346_d) || state.func_203425_a(Blocks.field_196660_k) || state.func_203425_a(Blocks.field_150458_ak) || state.func_203425_a(Blocks.field_196661_l) || state.func_203425_a(Blocks.field_150391_bh) || state.func_203425_a(Blocks.field_235381_mu_) || state.func_203425_a(Blocks.field_235372_ml_) || state.func_203425_a(Blocks.field_235336_cN_) || state.func_203425_a(Blocks.field_150426_aN) || state.func_203425_a((Block)IEBlocks.DIMSTONE.get()) || state.func_203425_a((Block)IEBlocks.DULLSTONE.get()) || state.func_203425_a((Block)IEBlocks.DULLTHORNS.get());
    }

    public boolean canAttach(IWorldReader reader, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.func_177972_a(direction);
        return this.isValidGround(reader.func_180495_p(blockpos), (IBlockReader)reader, blockpos);
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return !((AttachFace)state.func_177229_b((Property)field_196366_M)).equals((Object)AttachFace.WALL) && this.canAttach(worldIn, pos, LuminousFungusBlock.func_196365_i((BlockState)state).func_176734_d());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Vector3d vector3d = state.func_191059_e(worldIn, pos);
        switch ((AttachFace)state.func_177229_b((Property)field_196366_M)) {
            case FLOOR: {
                return FLOOR_SHAPE.func_197751_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
            }
        }
        return CEILING_SHAPE.func_197751_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.func_201670_d() && entityIn instanceof LivingEntity && entityIn.func_70089_S() && InfernalExpansionConfig.Miscellaneous.LUMINOUS_FUNGUS_GIVES_EFFECT.getBool()) {
            LivingEntity livingEntity = (LivingEntity)entityIn;
            livingEntity.func_195064_c(new EffectInstance((Effect)IEEffects.LUMINOUS.get(), 120, 0, true, true));
        }
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builderIn) {
        builderIn.func_206894_a(new Property[]{field_185512_D, field_196366_M, LIT});
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        Block block = ((HugeFungusConfig)IEConfiguredFeatures.DULLTHORN_TREE_PLANTED.field_222738_b).field_236303_f_.func_177230_c();
        Block block1 = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        return block1 == block;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return (double)rand.nextFloat() < 0.4;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        IEConfiguredFeatures.DULLTHORN_TREE_PLANTED.func_242765_a((ISeedReader)worldIn, worldIn.func_72863_F().func_201711_g(), rand, pos);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new LuminousFungusTileEntity();
    }
}

