/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.infernalstudios.infernalexp.init.IEEffects;

@OnlyIn(value=Dist.CLIENT)
public class InfectionHeartOverlay {
    protected int heartOffset;
    private static final ResourceLocation INFECTION_HEART_TEXTURE = new ResourceLocation("infernalexp", "textures/gui/infection_gui.png");

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPreRender(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HEALTH || event.isCanceled()) {
            return;
        }
        this.heartOffset = ForgeIngameGui.left_height;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPostRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HEALTH || event.isCanceled()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        int left = mc.func_228018_at_().func_198107_o() / 2 - 91;
        int top = mc.func_228018_at_().func_198087_p() - this.heartOffset;
        if (player.func_70660_b((Effect)IEEffects.INFECTION.get()) != null) {
            InfectionHeartOverlay.drawInfectionOverlay(mc, event.getMatrixStack(), left, top);
        }
    }

    public static void drawInfectionOverlay(Minecraft mc, MatrixStack matrixStack, int left, int top) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 0.01);
        ClientPlayerEntity player = mc.field_71439_g;
        float currentHealth = player.func_110143_aJ();
        int ticks = mc.field_71456_v.func_73834_c();
        Random rand = new Random();
        rand.setSeed((long)ticks * 312871L);
        float absorb = MathHelper.func_76123_f((float)player.func_110139_bj());
        boolean highlight = mc.field_71456_v.field_175191_F > (long)ticks && (mc.field_71456_v.field_175191_F - (long)ticks) / 3L % 2L == 1L;
        int healthRows = MathHelper.func_76123_f((float)((player.func_110138_aP() + absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        int regen = -1;
        if (player.func_70644_a(Effects.field_76428_l)) {
            regen = ticks % 25;
        }
        int TOP = 9 * (mc.field_71441_e.func_72912_H().func_76093_s() ? 1 : 0);
        int BACKGROUND = highlight ? 9 : 0;
        float absorbRemaining = absorb;
        mc.func_110434_K().func_110577_a(INFECTION_HEART_TEXTURE);
        RenderSystem.enableBlend();
        for (int i = MathHelper.func_76123_f((float)((player.func_110138_aP() + absorb) / 2.0f)) - 1; i >= 0; --i) {
            int row = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * rowHeight;
            if (currentHealth <= 4.0f) {
                y += rand.nextInt(2);
            }
            if (i == regen) {
                y -= 2;
            }
            mc.field_71456_v.func_238474_b_(matrixStack, x, y, BACKGROUND, TOP, 9, 9);
            if (highlight) {
                if (i * 2 + 1 < mc.field_71456_v.field_175189_D) {
                    mc.field_71456_v.func_238474_b_(matrixStack, x, y, 54, TOP, 9, 9);
                } else if (i * 2 + 1 == mc.field_71456_v.field_175189_D) {
                    mc.field_71456_v.func_238474_b_(matrixStack, x, y, 63, TOP, 9, 9);
                }
            }
            if (absorbRemaining > 0.0f) {
                if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                    mc.field_71456_v.func_238474_b_(matrixStack, x, y, 63, TOP, 9, 9);
                    absorbRemaining -= 1.0f;
                    continue;
                }
                mc.field_71456_v.func_238474_b_(matrixStack, x, y, 54, TOP, 9, 9);
                absorbRemaining -= 2.0f;
                continue;
            }
            if ((float)(i * 2 + 1) < currentHealth) {
                mc.field_71456_v.func_238474_b_(matrixStack, x, y, 36, TOP, 9, 9);
                continue;
            }
            if ((float)(i * 2 + 1) != currentHealth) continue;
            mc.field_71456_v.func_238474_b_(matrixStack, x, y, 45, TOP, 9, 9);
        }
        RenderSystem.disableBlend();
        matrixStack.func_227865_b_();
        mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
    }
}

