/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.entities.IResizable;
import org.infernalstudios.infernalexp.init.IESoundEvents;

public class BasaltGiantEntity
extends CreatureEntity
implements IAngerable,
IEntityAdditionalSpawnData,
IResizable {
    private static final RangedInteger RANGED_INT = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private int attackTimer;
    private int angerTime;
    private UUID angerTarget;
    private static final float BASE_ENTITY_HEIGHT = 5.0f;
    private static final float MIN_ENTITY_HEIGHT = 4.0f;
    private static final float MAX_ENTITY_HEIGHT = 6.0f;
    private static final DataParameter<Float> GIANT_SIZE = EntityDataManager.func_187226_a(BasaltGiantEntity.class, (IDataSerializer)DataSerializers.field_187193_c);

    public BasaltGiantEntity(EntityType<? extends BasaltGiantEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 2.0f;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        float size = this.field_70146_Z.nextFloat();
        size /= 2.5f;
        this.setEntitySize(size += 0.8f);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 56.0).func_233815_a_(Attributes.field_233823_f_, 12.0).func_233815_a_(Attributes.field_233824_g_, 2.0).func_233815_a_(Attributes.field_233820_c_, 30.0).func_233815_a_(Attributes.field_233821_d_, 0.45);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GIANT_SIZE, (Object)Float.valueOf(1.0f));
    }

    @Override
    public float getEntitySize() {
        return ((Float)this.field_70180_af.func_187225_a(GIANT_SIZE)).floatValue();
    }

    @Override
    public void setEntitySize(float size) {
        this.func_184212_Q().func_187227_b(GIANT_SIZE, (Object)Float.valueOf(size));
        this.func_226264_Z_();
        this.func_213323_x_();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("Size", this.getEntitySize());
    }

    public void func_70037_a(CompoundNBT compound) {
        this.setEntitySize(compound.func_74760_g("Size"));
        super.func_70037_a(compound);
    }

    public void func_213323_x_() {
        super.func_213323_x_();
        this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return super.func_213305_a(poseIn).func_220313_a(this.getEntitySize());
    }

    public void func_184206_a(DataParameter<?> key) {
        if (GIANT_SIZE.equals(key)) {
            this.func_213323_x_();
        }
        super.func_184206_a(key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.func_184185_a((SoundEvent)IESoundEvents.BASALT_GIANT_DEATH.get(), 1.0f, 1.0f);
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
        float f1 = (int)f > 0 ? f / 2.0f + (float)this.field_70146_Z.nextInt((int)f) : f;
        float f2 = (float)this.func_233637_b_(Attributes.field_233824_g_);
        if (entityIn instanceof PlayerEntity && ((PlayerEntity)entityIn).func_184607_cu().isShield((LivingEntity)((PlayerEntity)entityIn))) {
            this.attackFling(entityIn, f2 * 3.0f, 2.0);
            entityIn.field_70133_I = true;
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f1)) {
            this.attackFling(entityIn, f2, 0.6);
        }
        this.func_184185_a((SoundEvent)IESoundEvents.BASALT_GIANT_HURT.get(), 1.0f, 1.0f);
        return flag;
    }

    private void attackFling(Entity entityIn, float f2, double height) {
        ((LivingEntity)entityIn).func_233627_a_(f2, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
        entityIn.func_213317_d(entityIn.func_213322_ci().func_72441_c(0.0, height, 0.0));
        this.func_174815_a((LivingEntity)this, entityIn);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof AbstractArrowEntity) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.6, true));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        if (InfernalExpansionConfig.MobInteractions.SKELETON_ATTACK_GIANT.getBoolean()) {
            this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, SkeletonEntity.class, true, false));
        }
        if (InfernalExpansionConfig.MobInteractions.GIANT_ATTACK_MAGMA_CUBE.getBoolean()) {
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MagmaCubeEntity.class, true, false));
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeFloat(this.getEntitySize());
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.field_70180_af.func_187227_b(GIANT_SIZE, (Object)Float.valueOf(buffer.readFloat()));
    }

    protected int func_70693_a(PlayerEntity player) {
        return 73;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)IESoundEvents.BASALT_GIANT_AMBIENT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)IESoundEvents.BASALT_GIANT_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)IESoundEvents.BASALT_GIANT_HURT.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    public boolean func_230279_az_() {
        return true;
    }

    public int func_230256_F__() {
        return this.angerTime;
    }

    public void func_230260_a__(int time) {
        this.angerTime = time;
    }

    @Nullable
    public UUID func_230257_G__() {
        return this.angerTarget;
    }

    public void func_230259_a_(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public void func_230258_H__() {
        this.func_230260_a__(RANGED_INT.func_233018_a_(this.field_70146_Z));
    }
}

