/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.entities.GlowsquitoEntity;
import org.infernalstudios.infernalexp.init.IEEffects;

public class BlindsightEntity
extends MonsterEntity {
    private int jumpDuration;
    private int jumpTicks;
    private Random rand = new Random();

    public BlindsightEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233824_g_, 1.5).func_233815_a_(Attributes.field_233821_d_, 0.9).func_233815_a_(Attributes.field_233819_b_, 18.0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new FloatGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LeapGoal((MobEntity)this, 6.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new FaceRandomGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new HopGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        if (InfernalExpansionConfig.MobInteractions.BLINDSIGHT_ATTACK_GLOWSQUITO.getBoolean()) {
            this.field_70715_bh.func_75776_a(1, (Goal)new TargetGlowsquitoGoal((MobEntity)this, true, false));
        }
        if (InfernalExpansionConfig.MobInteractions.BLINDSIGHT_ATTACK_PLAYER.getBoolean()) {
            this.field_70715_bh.func_75776_a(2, new TargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, true, false));
        }
    }

    protected int func_70693_a(PlayerEntity player) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(4);
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getJumpCompletion(float adjustTicks) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + adjustTicks) / (float)this.jumpDuration;
    }

    public void func_70636_d() {
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
        }
        super.func_70636_d();
    }

    protected void func_70664_aZ() {
        this.jumpDuration = 10;
        this.jumpTicks = 0;
        float f = this.func_175134_bD() + this.rand.nextFloat() * 0.7f;
        Vector3d vector3d = this.func_213322_ci();
        this.func_213293_j(vector3d.field_72450_a, f, vector3d.field_72449_c);
        if (this.func_70051_ag()) {
            float f1 = this.field_70177_z * ((float)Math.PI / 180);
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-MathHelper.func_76126_a((float)f1) * 0.2f), 0.0, (double)(MathHelper.func_76134_b((float)f1) * 0.2f)));
        }
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((LivingEntity)this);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)1);
        }
    }

    public void func_70103_a(byte id) {
        if (id == 1) {
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    protected int getJumpDelay() {
        return (this.rand.nextInt(20) + 10) * 2;
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.field_187882_fq;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76379_h) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        if (entityIn instanceof GlowsquitoEntity || entityIn instanceof PlayerEntity) {
            this.dealDamage((LivingEntity)entityIn);
        }
    }

    protected void dealDamage(LivingEntity entityIn) {
        if (this.func_70089_S() && this.func_70685_l((Entity)entityIn) && entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_))) {
            entityIn.func_195064_c(new EffectInstance((Effect)IEEffects.LUMINOUS.get(), 600, 0, true, true));
            this.func_184185_a(SoundEvents.field_187870_fk, 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            this.func_174815_a((LivingEntity)this, (Entity)entityIn);
        }
    }

    static class FloatGoal
    extends Goal {
        private final BlindsightEntity blindsight;

        public FloatGoal(BlindsightEntity blindsightIn) {
            this.blindsight = blindsightIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            blindsightIn.func_70661_as().func_212239_d(true);
        }

        public boolean func_75250_a() {
            return (this.blindsight.func_70090_H() || this.blindsight.func_180799_ab()) && this.blindsight.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75246_d() {
            if (this.blindsight.func_70681_au().nextFloat() < 0.8f) {
                this.blindsight.func_70683_ar().func_75660_a();
            }
            ((MoveHelperController)this.blindsight.func_70605_aq()).setSpeed(1.2);
        }
    }

    static class FaceRandomGoal
    extends Goal {
        private final BlindsightEntity blindsight;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public FaceRandomGoal(BlindsightEntity blindsightIn) {
            this.blindsight = blindsightIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return this.blindsight.func_70638_az() == null && (this.blindsight.field_70122_E || this.blindsight.func_70090_H() || this.blindsight.func_180799_ab() || this.blindsight.func_70644_a(Effects.field_188424_y)) && this.blindsight.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.blindsight.func_70681_au().nextInt(60);
                this.chosenDegrees = this.blindsight.func_70681_au().nextInt(360);
            }
            ((MoveHelperController)this.blindsight.func_70605_aq()).setDirection(this.chosenDegrees);
        }
    }

    static class AttackGoal
    extends Goal {
        private final BlindsightEntity blindsight;
        private int growTieredTimer;

        public AttackGoal(BlindsightEntity blindsightIn) {
            this.blindsight = blindsightIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.blindsight.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            return this.blindsight.func_70605_aq() instanceof MoveHelperController;
        }

        public void func_75249_e() {
            this.growTieredTimer = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = this.blindsight.func_70638_az();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.func_70089_S()) {
                return false;
            }
            return --this.growTieredTimer > 0;
        }

        public void func_75246_d() {
            this.blindsight.func_70625_a((Entity)this.blindsight.func_70638_az(), 10.0f, 10.0f);
            ((MoveHelperController)this.blindsight.func_70605_aq()).setDirection(this.blindsight.field_70177_z);
        }
    }

    public static class MoveHelperController
    extends MovementController {
        private float yRot;
        private int jumpDelay;
        private final BlindsightEntity blindsight;

        public MoveHelperController(BlindsightEntity blindsightIn) {
            super((MobEntity)blindsightIn);
            this.blindsight = blindsightIn;
            this.yRot = 180.0f * blindsightIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float yRotIn) {
            this.yRot = yRotIn;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = MovementController.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != MovementController.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = MovementController.Action.WAIT;
                if (this.field_75648_a.func_233570_aj_()) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233821_d_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.blindsight.getJumpDelay() / 3;
                        this.blindsight.func_70683_ar().func_75660_a();
                        this.blindsight.func_184185_a(this.blindsight.getJumpSound(), this.blindsight.func_70599_aP(), 1.5f);
                    } else {
                        this.blindsight.field_70702_br = 0.0f;
                        this.blindsight.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233821_d_)));
                }
            }
        }
    }

    static class HopGoal
    extends Goal {
        private final BlindsightEntity blindsight;

        public HopGoal(BlindsightEntity blindsightIn) {
            this.blindsight = blindsightIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !this.blindsight.func_184218_aH() && this.blindsight.func_70638_az() != null;
        }

        public void func_75246_d() {
            ((MoveHelperController)this.blindsight.func_70605_aq()).setSpeed(1.0);
        }
    }

    static class TargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public TargetGoal(MobEntity goalOwnerIn, Class<T> targetClassIn, boolean checkSight, boolean nearbyOnlyIn) {
            super(goalOwnerIn, targetClassIn, checkSight, nearbyOnlyIn);
        }

        protected boolean func_220777_a(@Nullable LivingEntity potentialTarget, EntityPredicate targetPredicate) {
            return super.func_220777_a(potentialTarget, targetPredicate) && (this.field_75299_d.func_70068_e((Entity)this.field_75309_a) <= 10.0 || this.field_75299_d.func_70068_e((Entity)this.field_75309_a) > 10.0 && this.field_75309_a.func_70644_a((Effect)IEEffects.LUMINOUS.get()));
        }
    }

    static class TargetGlowsquitoGoal
    extends NearestAttackableTargetGoal<GlowsquitoEntity> {
        public TargetGlowsquitoGoal(MobEntity goalOwnerIn, boolean checkSight, boolean nearbyOnlyIn) {
            super(goalOwnerIn, GlowsquitoEntity.class, checkSight, nearbyOnlyIn);
        }

        protected AxisAlignedBB func_188511_a(double targetDistance) {
            return this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, 4.5, targetDistance);
        }
    }

    static class LeapGoal
    extends Goal {
        private final MobEntity leaper;
        private LivingEntity leapTarget;
        private final double maxJumpHeight;

        public LeapGoal(MobEntity leapingEntity, double maxJumpHeightIn) {
            this.leaper = leapingEntity;
            this.leapTarget = this.leaper.func_70638_az();
            this.maxJumpHeight = maxJumpHeightIn;
        }

        public boolean func_75250_a() {
            if (this.leaper.func_184207_aI()) {
                return false;
            }
            this.leapTarget = this.leaper.func_70638_az();
            if (this.leapTarget == null || !(this.leapTarget instanceof GlowsquitoEntity)) {
                return false;
            }
            double d0 = this.leapTarget.func_226278_cu_() - this.leaper.func_226278_cu_();
            double d1 = this.leapTarget.func_226277_ct_() - this.leaper.func_226277_ct_();
            double d2 = this.leapTarget.func_226281_cx_() - this.leaper.func_226281_cx_();
            double d3 = MathHelper.func_76133_a((double)(d1 * d1 + d2 * d2));
            if (!(d0 < 1.0 || d0 > this.maxJumpHeight || d3 > 3.0)) {
                if (!this.leaper.func_233570_aj_()) {
                    return false;
                }
                return this.leaper.func_70681_au().nextInt(5) == 0;
            }
            return false;
        }

        public void func_75249_e() {
            Vector3d vector3d = this.leaper.func_213322_ci();
            Vector3d vector3d1 = new Vector3d(this.leapTarget.func_226277_ct_() - this.leaper.func_226277_ct_(), this.leapTarget.func_226278_cu_() - this.leaper.func_226278_cu_(), this.leapTarget.func_226281_cx_() - this.leaper.func_226281_cx_());
            if (vector3d1.func_189985_c() > 1.0E-7) {
                vector3d1 = vector3d1.func_72432_b().func_186678_a(0.9).func_178787_e(vector3d.func_186678_a(0.2));
            }
            this.leaper.func_213293_j(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c);
        }
    }
}

