/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.EatGrassGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.entities.BlackstoneDwarfEntity;
import org.infernalstudios.infernalexp.entities.ai.TargetWithEffectGoal;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.init.IEEffects;
import org.infernalstudios.infernalexp.init.IEEntityTypes;
import org.infernalstudios.infernalexp.init.IESoundEvents;

public class GlowsquitoEntity
extends AnimalEntity
implements IFlyingAnimal {
    private static final DataParameter<Boolean> BRED = EntityDataManager.func_187226_a(GlowsquitoEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{((Block)IEBlocks.SHROOMLIGHT_FUNGUS.get()).func_199767_j()});
    private EatGrassGoal eatGrassGoal;
    private int hogTimer;

    public GlowsquitoEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 20, true);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 16.0f);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 32.0).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233822_e_, 0.6).func_233815_a_(Attributes.field_233821_d_, 0.5);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public GlowsquitoEntity createChild(ServerWorld world, AgeableEntity parent) {
        GlowsquitoEntity glowsquitoEntity = (GlowsquitoEntity)((EntityType)IEEntityTypes.GLOWSQUITO.get()).func_200721_a((World)world);
        glowsquitoEntity.setBred(true);
        return glowsquitoEntity;
    }

    public boolean func_70877_b(ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BRED, (Object)false);
    }

    public boolean getBred() {
        return (Boolean)this.field_70180_af.func_187225_a(BRED);
    }

    public void setBred(boolean isBred) {
        this.field_70180_af.func_187227_b(BRED, (Object)isBred);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Bred", this.getBred());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setBred(compound.func_74767_n("Bred"));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? sizeIn.field_220316_b * 0.35f : sizeIn.field_220316_b * 0.72f;
    }

    protected void func_82167_n(Entity entityIn) {
        super.func_82167_n(entityIn);
        if (!this.func_70631_g_() && entityIn instanceof LivingEntity && !(entityIn instanceof GlowsquitoEntity)) {
            ((LivingEntity)entityIn).func_195064_c(new EffectInstance((Effect)IEEffects.LUMINOUS.get(), 200));
        }
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, worldIn){

            public boolean func_188555_b(BlockPos pos) {
                return !this.field_75513_b.func_180495_p(pos.func_177977_b()).func_196958_f();
            }

            public void func_75501_e() {
                super.func_75501_e();
            }
        };
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(false);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.6, true));
        this.eatGrassGoal = new EatGrassGoal((MobEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.8, true));
        this.field_70714_bg.func_75776_a(1, (Goal)new MoveTowardsTargetGoal((CreatureEntity)this, 0.8, 32.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 0.8, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(8, (Goal)new WanderGoal());
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        if (InfernalExpansionConfig.MobInteractions.GLOWSQUITO_ATTACK_LUMINOUS.getBoolean()) {
            this.field_70715_bh.func_75776_a(1, (Goal)new TargetWithEffectGoal((MobEntity)this, LivingEntity.class, true, false, (Effect)IEEffects.LUMINOUS.get(), GlowsquitoEntity.class));
        }
        if (InfernalExpansionConfig.MobInteractions.GLOWSQUITO_ATTACK_DWARF.getBoolean()) {
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, BlackstoneDwarfEntity.class, true));
        }
    }

    public boolean func_230279_az_() {
        return true;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(4);
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)IESoundEvents.GLOWSQUITO_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)IESoundEvents.GLOWSQUITO_HURT.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!super.func_70652_k(entityIn)) {
            return false;
        }
        if (entityIn instanceof LivingEntity) {
            ((LivingEntity)entityIn).func_195064_c(new EffectInstance((Effect)IEEffects.LUMINOUS.get(), 600, 0, true, true));
            ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76436_u, 100));
        }
        return true;
    }

    protected void func_70619_bc() {
        this.hogTimer = this.eatGrassGoal.func_151499_f();
        super.func_70619_bc();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            this.hogTimer = Math.max(0, this.hogTimer - 1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.hogTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    class WanderGoal
    extends Goal {
        WanderGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return GlowsquitoEntity.this.field_70699_by.func_75500_f() && GlowsquitoEntity.this.field_70146_Z.nextInt(10) == 0;
        }

        public boolean func_75253_b() {
            return GlowsquitoEntity.this.field_70699_by.func_226337_n_();
        }

        public void func_75249_e() {
            Vector3d vector3d = this.getRandomLocation();
            if (vector3d != null) {
                GlowsquitoEntity.this.field_70699_by.func_75484_a(GlowsquitoEntity.this.field_70699_by.func_179680_a(new BlockPos(vector3d), 1), 1.0);
            }
        }

        @Nullable
        private Vector3d getRandomLocation() {
            Vector3d vector3d = GlowsquitoEntity.this.func_70676_i(0.0f);
            Vector3d vector3d2 = RandomPositionGenerator.func_226340_a_((CreatureEntity)GlowsquitoEntity.this, (int)8, (int)7, (Vector3d)vector3d, (float)1.5707964f, (int)2, (int)1);
            return vector3d2 != null ? vector3d2 : RandomPositionGenerator.func_226338_a_((CreatureEntity)GlowsquitoEntity.this, (int)8, (int)4, (int)-2, (Vector3d)vector3d, (double)1.5707963705062866);
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final GlowsquitoEntity parentEntity;

        public RandomFlyGoal(GlowsquitoEntity glowsquito) {
            this.parentEntity = glowsquito;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            MovementController movementcontroller = this.parentEntity.func_70605_aq();
            if (!movementcontroller.func_75640_a()) {
                return true;
            }
            double d0 = movementcontroller.func_179917_d() - this.parentEntity.func_226277_ct_();
            double d3 = d0 * d0 + (d1 = movementcontroller.func_179919_e() - this.parentEntity.func_226278_cu_()) * d1 + (d2 = movementcontroller.func_179918_f() - this.parentEntity.func_226281_cx_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.func_226277_ct_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.func_226278_cu_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.func_226281_cx_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final GlowsquitoEntity parentEntity;
        private int courseChangeCooldown;

        public MoveHelperController(GlowsquitoEntity ghast) {
            super((MobEntity)ghast);
            this.parentEntity = ghast;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                Vector3d vector3d = new Vector3d(this.field_75646_b - this.parentEntity.func_226277_ct_(), this.field_75647_c - this.parentEntity.func_226278_cu_(), this.field_75644_d - this.parentEntity.func_226281_cx_());
                double d0 = vector3d.func_72433_c();
                if (this.func_220673_a(vector3d = vector3d.func_72432_b(), MathHelper.func_76143_f((double)d0))) {
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(vector3d.func_186678_a(0.1)));
                } else {
                    this.field_188491_h = MovementController.Action.WAIT;
                }
            }
        }

        private boolean func_220673_a(Vector3d p_220673_1_, int p_220673_2_) {
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.parentEntity.field_70170_p.func_226665_a__((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_191194_a(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final GlowsquitoEntity parentEntity;

        public LookAroundGoal(GlowsquitoEntity ghast) {
            this.parentEntity = ghast;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            Vector3d vector3d = this.parentEntity.func_213322_ci();
            this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c)) * 57.295776f;
        }
    }
}

