/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import org.infernalstudios.infernalexp.entities.AscusBombEntity;
import org.infernalstudios.infernalexp.init.IEEffects;
import org.infernalstudios.infernalexp.init.IEItems;
import org.infernalstudios.infernalexp.init.IEShroomloinTypes;
import org.infernalstudios.infernalexp.init.IESoundEvents;
import org.infernalstudios.infernalexp.util.ShroomloinType;

public class ShroomloinEntity
extends CreatureEntity
implements IRangedAttackMob {
    private static final DataParameter<String> TYPE = EntityDataManager.func_187226_a(ShroomloinEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(ShroomloinEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(ShroomloinEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CONVERTING = EntityDataManager.func_187226_a(ShroomloinEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int lastActiveTime;
    private int timeSinceIgnited;
    private final int fuseTime = 59;
    private int conversionTicks;
    private ShroomloinType predictedType;

    public ShroomloinEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233823_f_, 1.5).func_233815_a_(Attributes.field_233824_g_, 1.5).func_233815_a_(Attributes.field_233821_d_, 0.6);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
        this.field_70180_af.func_187214_a(CONVERTING, (Object)false);
        this.field_70180_af.func_187214_a(TYPE, (Object)IEShroomloinTypes.CRIMSON.getId().toString());
    }

    public boolean isConverting() {
        return (Boolean)this.field_70180_af.func_187225_a(CONVERTING);
    }

    public void setConverting(boolean converting) {
        this.field_70180_af.func_187227_b(CONVERTING, (Object)converting);
    }

    public boolean isShaking() {
        return this.isConverting();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("ShroomloinType", this.getShroomloinType().getId().toString());
        compound.func_74768_a("ShroomloinConversionTime", this.isConverting() ? this.conversionTicks : -1);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setShroomloinType(ShroomloinType.getById(compound.func_74779_i("ShroomloinType")));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ResourceLocation biome = worldIn.func_226691_t_(this.func_233580_cy_()).getRegistryName();
        if (reason == SpawnReason.NATURAL && ModList.get().isLoaded("byg")) {
            if (biome.equals((Object)new ResourceLocation("byg", "glowstone_gardens"))) {
                if (this.field_70146_Z.nextBoolean()) {
                    this.setShroomloinType(IEShroomloinTypes.SOUL_SHROOM);
                } else {
                    this.setShroomloinType(IEShroomloinTypes.DEATH_CAP);
                }
            } else if (biome.equals((Object)new ResourceLocation("byg", "embur_bog"))) {
                this.setShroomloinType(IEShroomloinTypes.EMBUR);
            } else if (biome.equals((Object)new ResourceLocation("byg", "sythian_torrids"))) {
                this.setShroomloinType(IEShroomloinTypes.SYTHIAN_FUNGUS);
            }
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void setShroomloinType(ShroomloinType shroomloinType) {
        this.field_70180_af.func_187227_b(TYPE, (Object)shroomloinType.getId().toString());
    }

    public ShroomloinType getShroomloinType() {
        return ShroomloinType.getById((String)this.field_70180_af.func_187225_a(TYPE));
    }

    public Item getConversionItem() {
        return this.getShroomloinType().getConversionItem();
    }

    protected ActionResultType func_230254_b_(PlayerEntity playerIn, Hand hand) {
        if (this.isConverting()) {
            return ActionResultType.FAIL;
        }
        ItemStack stack = playerIn.func_184586_b(hand);
        ShroomloinType shroomloinType = ShroomloinType.getByItem(stack.func_77973_b());
        if (shroomloinType == null || shroomloinType.getConversionItem() == null) {
            return super.func_230254_b_(playerIn, hand);
        }
        if (shroomloinType.getId().equals((Object)this.getShroomloinType().getId()) || shroomloinType == IEShroomloinTypes.PIZZA) {
            return ActionResultType.FAIL;
        }
        this.predictedType = shroomloinType;
        this.conversionTicks = 40;
        this.setConverting(true);
        if (!playerIn.func_184812_l_()) {
            stack.func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            if (this.func_200200_C_().func_150261_e().equals("pizza") && this.getShroomloinType() != IEShroomloinTypes.PIZZA && this.predictedType != IEShroomloinTypes.PIZZA) {
                this.predictedType = IEShroomloinTypes.PIZZA;
                this.conversionTicks = 40;
                this.setConverting(true);
            }
            if (this.isConverting() && this.conversionTicks > 0) {
                --this.conversionTicks;
                this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.2);
                if (this.conversionTicks == 0) {
                    this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.6);
                    this.setShroomloinType(this.predictedType);
                    this.setConverting(false);
                }
            }
            if (this.func_70644_a((Effect)IEEffects.INFECTION.get())) {
                this.func_184596_c((Effect)IEEffects.INFECTION.get());
            }
            if (this.func_70644_a(Effects.field_76436_u)) {
                this.func_184596_c(Effects.field_76436_u);
            }
        }
        this.lastActiveTime = this.timeSinceIgnited;
        int i = this.getShroomloinState();
        if (i > 0 && this.timeSinceIgnited == 0) {
            this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
        }
        this.timeSinceIgnited += i;
        if (this.timeSinceIgnited < 0 || this.timeSinceIgnited >= this.fuseTime || i < 0) {
            this.timeSinceIgnited = 0;
        }
        super.func_70071_h_();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new RangedAttackUnInfectedGoal(this, 1.0, 60, 10.0f));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackInfectedGoal(this, 0.6, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShroomloinFlashIntensity(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.lastActiveTime, (float)this.timeSinceIgnited) / (float)(this.fuseTime - 2);
    }

    public int getShroomloinState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setShroomloinState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public void becomeAngryAt(LivingEntity entity) {
        this.func_70624_b(entity);
    }

    protected int func_70693_a(PlayerEntity player) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(4);
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)IESoundEvents.SHROOMLOIN_AMBIENT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)IESoundEvents.SHROOMLOIN_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)IESoundEvents.SHROOMLOIN_HURT.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        Vector3d vector3d = target.func_213322_ci();
        double x = target.func_226277_ct_() + vector3d.field_72450_a - this.func_226277_ct_();
        double y = target.func_226280_cw_() - 1.1 - this.func_226278_cu_();
        double z = target.func_226281_cx_() + vector3d.field_72449_c - this.func_226281_cx_();
        float distance = MathHelper.func_76133_a((double)(x * x + z * z));
        AscusBombEntity ascusBombEntity = new AscusBombEntity(this.field_70170_p, (LivingEntity)this);
        ascusBombEntity.func_213884_b(new ItemStack((IItemProvider)IEItems.ASCUS_BOMB.get()));
        ascusBombEntity.field_70125_A -= -20.0f;
        ascusBombEntity.func_70186_c(x, y + (double)distance * 0.2, z, 0.75f, 8.0f);
        this.setShroomloinState(-1);
        this.field_70170_p.func_217376_c((Entity)ascusBombEntity);
    }

    static class RangedAttackUnInfectedGoal
    extends Goal {
        private final ShroomloinEntity entityHost;
        private final IRangedAttackMob rangedAttackEntityHost;
        private LivingEntity attackTarget;
        private int rangedAttackTime = -1;
        private final double entityMoveSpeed;
        private int seeTime;
        private final int attackIntervalMin;
        private final int maxRangedAttackTime;
        private final float attackRadius;
        private final float maxAttackDistance;

        public RangedAttackUnInfectedGoal(IRangedAttackMob attacker, double movespeed, int maxAttackTime, float maxAttackDistanceIn) {
            this(attacker, movespeed, maxAttackTime, maxAttackTime, maxAttackDistanceIn);
        }

        public RangedAttackUnInfectedGoal(IRangedAttackMob attacker, double movespeed, int p_i1650_4_, int maxAttackTime, float maxAttackDistanceIn) {
            if (!(attacker instanceof LivingEntity)) {
                throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
            }
            this.rangedAttackEntityHost = attacker;
            this.entityHost = (ShroomloinEntity)attacker;
            this.entityMoveSpeed = movespeed;
            this.attackIntervalMin = p_i1650_4_;
            this.maxRangedAttackTime = maxAttackTime;
            this.attackRadius = maxAttackDistanceIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity attackTarget = this.entityHost.func_70638_az();
            if (attackTarget != null && attackTarget.func_70089_S() && !attackTarget.func_70644_a((Effect)IEEffects.INFECTION.get())) {
                this.attackTarget = attackTarget;
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.func_75250_a() || !this.entityHost.func_70661_as().func_75500_f();
        }

        public void func_75251_c() {
            this.attackTarget = null;
            this.seeTime = 0;
            this.rangedAttackTime = -1;
            this.entityHost.setShroomloinState(-1);
        }

        public void func_75246_d() {
            double d0 = this.entityHost.func_70092_e(this.attackTarget.func_226277_ct_(), this.attackTarget.func_226278_cu_(), this.attackTarget.func_226281_cx_());
            boolean flag = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
            this.seeTime = flag ? ++this.seeTime : 0;
            if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 5) {
                this.entityHost.func_70661_as().func_75499_g();
            } else {
                this.entityHost.setShroomloinState(-1);
                this.entityHost.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
            }
            this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            if (--this.rangedAttackTime == 0) {
                if (!flag) {
                    return;
                }
                float f = MathHelper.func_76133_a((double)d0) / this.attackRadius;
                float lvt_5_1_ = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
                this.rangedAttackEntityHost.func_82196_d(this.attackTarget, lvt_5_1_);
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.rangedAttackTime < 0) {
                float f2 = MathHelper.func_76133_a((double)d0) / this.attackRadius;
                this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else {
                this.entityHost.setShroomloinState(1);
            }
        }
    }

    static class MeleeAttackInfectedGoal
    extends MeleeAttackGoal {
        public MeleeAttackInfectedGoal(CreatureEntity creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
        }

        public boolean func_75250_a() {
            LivingEntity attackTarget = this.field_75441_b.func_70638_az();
            if (attackTarget != null && !attackTarget.func_70644_a((Effect)IEEffects.INFECTION.get())) {
                return false;
            }
            return super.func_75250_a();
        }

        public boolean func_75253_b() {
            LivingEntity attackTarget = this.field_75441_b.func_70638_az();
            if (attackTarget != null && !attackTarget.func_70644_a((Effect)IEEffects.INFECTION.get())) {
                return false;
            }
            return super.func_75253_b();
        }
    }
}

