/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.entities;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.entities.ShroomloinEntity;
import org.infernalstudios.infernalexp.entities.ai.TeleportPanicGoal;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.init.IESoundEvents;

public class WarpbeetleEntity
extends CreatureEntity {
    private int attackTimer;
    private int conversionTicks;
    private static final DataParameter<Boolean> CONVERTING = EntityDataManager.func_187226_a(ShroomloinEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> CHORUS = EntityDataManager.func_187226_a(WarpbeetleEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float shellRotationMultiplier = 0.0f;
    public static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_234722_bw_, ((Block)IEBlocks.CRIMSON_FUNGUS_CAP.get()).func_199767_j()});

    public WarpbeetleEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233821_d_, 0.4).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233824_g_, 2.0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.6, true));
        this.field_70714_bg.func_75776_a(1, (Goal)new TeleportPanicGoal(this, 1.4));
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal((CreatureEntity)this, 2.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 0.6, TEMPTATION_ITEMS, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        if (InfernalExpansionConfig.MobInteractions.SPIDER_ATTACK_WARPBEETLE.getBoolean()) {
            this.field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)this, SpiderEntity.class, true, false));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CONVERTING, (Object)false);
        this.field_70180_af.func_187214_a(CHORUS, (Object)false);
    }

    public boolean isConverting() {
        return (Boolean)this.field_70180_af.func_187225_a(CONVERTING);
    }

    public void setConverting(boolean converting) {
        this.field_70180_af.func_187227_b(CONVERTING, (Object)converting);
    }

    public boolean isShaking() {
        return this.isConverting();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("chorus", this.isChorus());
        compound.func_74768_a("WarpbeetleConversionTime", this.isConverting() ? this.conversionTicks : -1);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setChorus(compound.func_74767_n("chorus"));
    }

    public boolean isChorus() {
        return (Boolean)this.field_70180_af.func_187225_a(CHORUS);
    }

    public void setChorus(boolean chorus) {
        this.field_70180_af.func_187227_b(CHORUS, (Object)chorus);
    }

    protected ActionResultType func_230254_b_(PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (this.isConverting()) {
            return ActionResultType.FAIL;
        }
        if (!this.isChorus() && stack.func_77973_b() == Items.field_185161_cS) {
            this.conversionTicks = 40;
            this.setConverting(true);
            if (!playerIn.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.isChorus() && stack.func_77973_b() == Items.field_234723_bx_) {
            this.conversionTicks = 40;
            this.setConverting(true);
            if (!playerIn.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(playerIn, hand);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.func_70089_S() && this.isConverting() && this.conversionTicks > 0) {
            --this.conversionTicks;
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.2);
            if (this.conversionTicks == 0) {
                this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.4);
                this.setChorus(!this.isChorus());
                this.setConverting(false);
            }
        }
        Vector3d vector3d = this.func_213322_ci();
        if (!this.field_70122_E && vector3d.field_72448_b < 0.0) {
            this.func_213317_d(vector3d.func_216372_d(1.0, 0.6, 1.0));
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        float f = this.getAttackDamage();
        float f1 = (int)f > 0 ? f / 2.0f + (float)this.field_70146_Z.nextInt((int)f) : f;
        float f2 = (float)this.func_233637_b_(Attributes.field_233824_g_);
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f1);
        if (flag) {
            ((LivingEntity)entityIn).func_233627_a_(f2 * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            entityIn.func_213317_d(entityIn.func_213322_ci().func_216372_d(1.0, 2.5, 1.0));
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        this.func_184185_a((SoundEvent)IESoundEvents.WARPBEETLE_HURT.get(), 1.0f, 1.0f);
        return flag;
    }

    private float getAttackDamage() {
        return (float)this.func_233637_b_(Attributes.field_233823_f_);
    }

    protected int func_70693_a(PlayerEntity player) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(4);
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)IESoundEvents.WARPBEETLE_AMBIENT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)IESoundEvents.WARPBEETLE_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)IESoundEvents.WARPBEETLE_HURT.get();
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }
}

