/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.events;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.PotionColorCalculationEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.infernalstudios.infernalexp.blocks.BuriedBoneBlock;
import org.infernalstudios.infernalexp.blocks.DullthornsBlock;
import org.infernalstudios.infernalexp.blocks.HorizontalBushBlock;
import org.infernalstudios.infernalexp.blocks.PlantedQuartzBlock;
import org.infernalstudios.infernalexp.config.ConfigHelper;
import org.infernalstudios.infernalexp.config.ConfigHolder;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.data.SpawnrateManager;
import org.infernalstudios.infernalexp.data.VolineEatTable;
import org.infernalstudios.infernalexp.entities.ShroomloinEntity;
import org.infernalstudios.infernalexp.entities.ThrowableBrickEntity;
import org.infernalstudios.infernalexp.entities.ThrowableFireChargeEntity;
import org.infernalstudios.infernalexp.entities.ThrowableMagmaCreamEntity;
import org.infernalstudios.infernalexp.entities.ThrowableNetherBrickEntity;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.init.IEEffects;
import org.infernalstudios.infernalexp.init.IEItems;
import org.infernalstudios.infernalexp.init.IEParticleTypes;
import org.infernalstudios.infernalexp.init.IEShroomloinTypes;
import org.infernalstudios.infernalexp.init.IESoundEvents;
import org.infernalstudios.infernalexp.init.IETags;

@Mod.EventBusSubscriber(modid="infernalexp", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MiscEvents {
    private static VolineEatTable volineEatTable;
    private static SpawnrateManager spawnrateManager;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == ConfigHolder.CLIENT_SPEC) {
            ConfigHelper.bakeClient(config);
        } else if (config.getSpec() == ConfigHolder.COMMON_SPEC) {
            ConfigHelper.bakeCommon(config);
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        int cost = event.getCost();
        if (left.func_77984_f() && right.func_77973_b() == IEItems.GLOWSILK.get() && !left.func_77973_b().func_206844_a(IETags.Items.GLOWSILK_REPAIR_BLACKLIST)) {
            if (left.func_77952_i() == 0) {
                return;
            }
            ItemStack output = left.func_77946_l();
            output.func_196085_b(left.func_77952_i() - 200);
            cost += 4;
            if (event.getName().equals("")) {
                if (left.func_82837_s()) {
                    ++cost;
                    output.func_135074_t();
                }
            } else if (!left.func_200301_q().getString().equals(event.getName())) {
                ++cost;
                output.func_200302_a((ITextComponent)new StringTextComponent(event.getName()));
            }
            event.setMaterialCost(1);
            event.setCost(cost);
            event.setOutput(output);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockState state = event.getState();
        List list = event.getPlayer().field_70170_p.func_217357_a(ShroomloinEntity.class, event.getPlayer().func_174813_aQ().func_186662_g(32.0));
        for (int j = 0; j < list.size(); ++j) {
            Entity entity = (Entity)list.get(j);
            if (!(entity instanceof ShroomloinEntity)) continue;
            ShroomloinEntity shroomloinEntity = (ShroomloinEntity)entity;
            if (shroomloinEntity.getShroomloinType() == IEShroomloinTypes.CRIMSON && state.func_177230_c().func_203417_a(IETags.Blocks.ANGER_CRIMSON_SHROOMLOIN_BLOCKS)) {
                shroomloinEntity.becomeAngryAt((LivingEntity)event.getPlayer());
            }
            if (shroomloinEntity.getShroomloinType() == IEShroomloinTypes.WARPED && state.func_177230_c().func_203417_a(IETags.Blocks.ANGER_WARPED_SHROOMLOIN_BLOCKS)) {
                shroomloinEntity.becomeAngryAt((LivingEntity)event.getPlayer());
            }
            if (shroomloinEntity.getShroomloinType() == IEShroomloinTypes.LUMINOUS && state.func_177230_c().func_203417_a(IETags.Blocks.ANGER_LUMINOUS_SHROOMLOIN_BLOCKS)) {
                shroomloinEntity.becomeAngryAt((LivingEntity)event.getPlayer());
            }
            if (shroomloinEntity.getShroomloinType() == IEShroomloinTypes.RED && state.func_177230_c().func_203417_a(IETags.Blocks.ANGER_RED_SHROOMLOIN_BLOCKS)) {
                shroomloinEntity.becomeAngryAt((LivingEntity)event.getPlayer());
            }
            if (shroomloinEntity.getShroomloinType() != IEShroomloinTypes.BROWN || !state.func_177230_c().func_203417_a(IETags.Blocks.ANGER_BROWN_SHROOMLOIN_BLOCKS)) continue;
            shroomloinEntity.becomeAngryAt((LivingEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack heldItemStack = event.getItemStack();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        Direction face = event.getFace();
        PlayerEntity player = event.getPlayer();
        if (heldItemStack.func_77973_b() == Items.field_151103_aS) {
            pos = pos.func_177972_a(face);
            BlockState blockstate = ((BuriedBoneBlock)IEBlocks.BURIED_BONE.get()).getPlaceableState(world, pos, face);
            if (blockstate != null) {
                player.func_184609_a(event.getHand());
                if (!world.func_175623_d(pos) && !world.func_201670_d() && world.func_180495_p(pos).func_204520_s().func_206888_e()) {
                    world.func_175655_b(pos, true);
                }
                world.func_180501_a(pos, blockstate, 3);
                world.func_184133_a(player, pos, blockstate.func_215695_r().func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!player.func_184812_l_()) {
                    heldItemStack.func_190918_g(1);
                }
                ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)pos), (Direction)face);
            }
        } else if (heldItemStack.func_77973_b() == Items.field_151128_bU) {
            pos = pos.func_177972_a(face);
            BlockState blockstate = ((PlantedQuartzBlock)IEBlocks.PLANTED_QUARTZ.get()).getPlaceableState(world, pos, face);
            if (blockstate != null) {
                player.func_184609_a(event.getHand());
                if (!world.func_175623_d(pos) && !world.func_201670_d() && world.func_180495_p(pos).func_204520_s().func_206888_e()) {
                    world.func_175655_b(pos, true);
                }
                world.func_180501_a(pos, blockstate, 3);
                world.func_184133_a(player, pos, blockstate.func_215695_r().func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!player.func_184812_l_()) {
                    heldItemStack.func_190918_g(1);
                }
                ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)pos), (Direction)face);
            }
        } else if (heldItemStack.func_77973_b() == Items.field_151114_aO) {
            if (heldItemStack.func_190916_E() >= 2) {
                if (world.func_180495_p(pos).func_177230_c() == IEBlocks.DIMSTONE.get()) {
                    player.func_184609_a(event.getHand());
                    for (int i = 0; i < 20; ++i) {
                        world.func_195594_a((IParticleData)IEParticleTypes.GLOWSTONE_SPARKLE.get(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0, 0.0, 0.0);
                    }
                    world.func_184133_a(null, event.getPos(), (SoundEvent)IESoundEvents.GLOWSTONE_RECHARGE.get(), SoundCategory.BLOCKS, 1.0f, (float)(0.75 + event.getWorld().func_201674_k().nextDouble() / 2.0));
                    world.func_175656_a(pos, Blocks.field_150426_aN.func_176223_P());
                    if (!player.func_184812_l_()) {
                        heldItemStack.func_190918_g(2);
                    }
                } else if (world.func_180495_p(pos).func_177230_c() == IEBlocks.DULLSTONE.get()) {
                    player.func_184609_a(event.getHand());
                    for (int i = 0; i < 20; ++i) {
                        world.func_195594_a((IParticleData)IEParticleTypes.GLOWSTONE_SPARKLE.get(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0, 0.0, 0.0);
                    }
                    world.func_184133_a(null, event.getPos(), (SoundEvent)IESoundEvents.GLOWSTONE_RECHARGE.get(), SoundCategory.BLOCKS, 1.0f, (float)(0.5 + event.getWorld().func_201674_k().nextDouble() / 3.0));
                    world.func_175656_a(pos, ((Block)IEBlocks.DIMSTONE.get()).func_176223_P());
                    if (!player.func_184812_l_()) {
                        heldItemStack.func_190918_g(2);
                    }
                }
            }
            if (world.func_180495_p(pos).func_177230_c() == IEBlocks.DULLTHORNS.get()) {
                player.func_184609_a(event.getHand());
                ((DullthornsBlock)world.func_180495_p(pos).func_177230_c()).bonemealGrow(world.func_180495_p(pos), world, pos);
                world.func_217379_c(2005, pos, 0);
                if (!player.func_184812_l_()) {
                    heldItemStack.func_190918_g(1);
                }
            }
        }
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        World world = event.getWorld();
        PlayerEntity player = event.getPlayer();
        ItemStack heldItemStack = player.func_184586_b(event.getHand());
        if (heldItemStack.func_77973_b() == Items.field_151064_bs) {
            player.func_184609_a(event.getHand());
            if (!world.field_72995_K) {
                ThrowableMagmaCreamEntity throwableMagmaCreamEntity = new ThrowableMagmaCreamEntity(world, (LivingEntity)player);
                throwableMagmaCreamEntity.func_213884_b(heldItemStack);
                throwableMagmaCreamEntity.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, -20.0f, 0.5f, 1.0f);
                world.func_217376_c((Entity)throwableMagmaCreamEntity);
                world.func_184133_a(null, event.getPos(), SoundEvents.field_187797_fA, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)heldItemStack.func_77973_b()));
            if (!player.field_71075_bZ.field_75098_d) {
                heldItemStack.func_190918_g(1);
            }
        } else if (heldItemStack.func_77973_b() == Items.field_151059_bz) {
            player.func_184609_a(event.getHand());
            if (!world.field_72995_K) {
                ThrowableFireChargeEntity throwableFireChargeEntity = new ThrowableFireChargeEntity(world, (LivingEntity)player, player.func_70040_Z().func_82615_a(), player.func_70040_Z().func_82617_b(), player.func_70040_Z().func_82616_c());
                world.func_217376_c((Entity)throwableFireChargeEntity);
                world.func_184133_a(null, event.getPos(), SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)heldItemStack.func_77973_b()));
            if (!player.field_71075_bZ.field_75098_d) {
                heldItemStack.func_190918_g(1);
            }
        }
        if (InfernalExpansionConfig.Miscellaneous.USE_THROWABLE_BRICKS.getBool()) {
            if (heldItemStack.func_77973_b() == Items.field_151118_aC) {
                player.func_184609_a(event.getHand());
                if (!world.field_72995_K) {
                    ThrowableBrickEntity throwableBrickEntity = new ThrowableBrickEntity(world, (LivingEntity)player);
                    throwableBrickEntity.func_213884_b(heldItemStack);
                    throwableBrickEntity.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, -20.0f, 0.5f, 1.0f);
                    world.func_217376_c((Entity)throwableBrickEntity);
                    world.func_184133_a(null, event.getPos(), SoundEvents.field_187797_fA, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)heldItemStack.func_77973_b()));
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItemStack.func_190918_g(1);
                }
            }
            if (heldItemStack.func_77973_b() == Items.field_196154_dH) {
                player.func_184609_a(event.getHand());
                if (!world.field_72995_K) {
                    ThrowableNetherBrickEntity throwableNetherBrickEntity = new ThrowableNetherBrickEntity(world, (LivingEntity)player);
                    throwableNetherBrickEntity.func_213884_b(heldItemStack);
                    throwableNetherBrickEntity.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, -20.0f, 0.3f, 1.0f);
                    world.func_217376_c((Entity)throwableNetherBrickEntity);
                    world.func_184133_a(null, event.getPos(), SoundEvents.field_187797_fA, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)heldItemStack.func_77973_b()));
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItemStack.func_190918_g(1);
                }
            }
        }
    }

    @SubscribeEvent
    public void onApplyBonemeal(BonemealEvent event) {
        Block block = event.getBlock().func_177230_c();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (block == Blocks.field_235383_mw_ && InfernalExpansionConfig.Miscellaneous.SHROOMLIGHT_GROWABLE.getBool()) {
            if (world.func_175623_d(pos = pos.func_177977_b())) {
                event.setResult(Event.Result.ALLOW);
                if (world.func_201674_k().nextDouble() < InfernalExpansionConfig.Miscellaneous.SHROOMLIGHT_GROW_CHANCE.getDouble() && !world.func_201670_d()) {
                    world.func_180501_a(pos, (BlockState)((Block)IEBlocks.SHROOMLIGHT_FUNGUS.get()).func_176223_P().func_206870_a((Property)HorizontalBushBlock.field_196366_M, (Comparable)AttachFace.CEILING), 3);
                }
            }
        } else if (block == IEBlocks.DULLTHORNS.get() && ((DullthornsBlock)world.func_180495_p(pos).func_177230_c()).bonemealGrow(world.func_180495_p(pos), world, pos)) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onPotionColorCalculate(PotionColorCalculationEvent event) {
        ArrayList effects = new ArrayList(event.getEffects());
        int customEffects = 0;
        for (EffectInstance effectInstance : effects) {
            if (effectInstance.func_188419_a() != IEEffects.INFECTION.get() && effectInstance.func_188419_a() != IEEffects.LUMINOUS.get()) continue;
            ++customEffects;
        }
        if (customEffects == effects.size()) {
            event.shouldHideParticles(true);
        }
    }

    @SubscribeEvent
    public void onLivingEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.func_70613_aW() && entity.func_130014_f_() instanceof ServerWorld) {
            if (entity.func_70644_a((Effect)IEEffects.INFECTION.get()) && (entity.func_70660_b((Effect)IEEffects.INFECTION.get()).func_76459_b() & 0xA) == 0 && entity.func_70660_b((Effect)IEEffects.INFECTION.get()).func_188418_e()) {
                ((ServerWorld)entity.func_130014_f_()).func_195598_a((IParticleData)IEParticleTypes.INFECTION.get(), entity.func_226282_d_(entity.func_174813_aQ().func_216364_b()), entity.func_226279_cv_(), entity.func_226287_g_(entity.func_174813_aQ().func_216362_d()), 0, 0.0, 0.0, 0.0, 1.0);
            }
            if (entity.func_70644_a((Effect)IEEffects.LUMINOUS.get())) {
                if ((entity.func_70660_b((Effect)IEEffects.LUMINOUS.get()).func_76459_b() & 0x32) == 0 && entity.func_70660_b((Effect)IEEffects.LUMINOUS.get()).func_188418_e()) {
                    ((ServerWorld)entity.func_130014_f_()).func_195598_a((IParticleData)IEParticleTypes.GLOWSTONE_SPARKLE.get(), entity.func_226282_d_(entity.func_174813_aQ().func_216364_b()), entity.func_226279_cv_(), entity.func_226287_g_(entity.func_174813_aQ().func_216362_d()), 0, 0.0, 0.0, 0.0, 0.2);
                }
                if (entity instanceof ZombieEntity && !(entity instanceof ZombifiedPiglinEntity) || entity instanceof SkeletonEntity) {
                    entity.func_70015_d(1);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingFinishUse(LivingEntityUseItemEvent.Finish event) {
        ItemStack item = event.getItem();
        LivingEntity entity = (LivingEntity)event.getEntity();
        if (item.func_77973_b() == IEItems.CURED_JERKY.get() && item.func_77975_n() == UseAction.EAT) {
            entity.func_195064_c(new EffectInstance(Effects.field_76424_c, 20 * InfernalExpansionConfig.Miscellaneous.JERKY_EFFECT_DURATION.getInt(), InfernalExpansionConfig.Miscellaneous.JERKY_EFFECT_AMPLIFIER.getInt()));
        }
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof AreaEffectCloudEntity) {
            for (EffectInstance effect : ((AreaEffectCloudEntity)event.getEntity()).field_184502_e.func_185170_a()) {
                if (effect.func_188419_a() == IEEffects.INFECTION.get()) {
                    ((AreaEffectCloudEntity)event.getEntity()).func_195059_a((IParticleData)IEParticleTypes.INFECTION.get());
                    continue;
                }
                if (effect.func_188419_a() != IEEffects.LUMINOUS.get()) continue;
                ((AreaEffectCloudEntity)event.getEntity()).func_195059_a((IParticleData)IEParticleTypes.GLOWSTONE_SPARKLE.get());
            }
        }
    }

    @SubscribeEvent
    public void onLivingEntityAttack(LivingAttackEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.func_70613_aW() && entity.func_130014_f_() instanceof ServerWorld && entity.func_70644_a((Effect)IEEffects.INFECTION.get()) && event.getSource() != DamageSource.field_76376_m) {
            for (int i = 0; i < 32; ++i) {
                ((ServerWorld)entity.func_130014_f_()).func_195598_a((IParticleData)IEParticleTypes.INFECTION.get(), entity.func_226282_d_(1.0), entity.func_226279_cv_(), entity.func_226287_g_(1.0), 1, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }

    @SubscribeEvent
    public void onResourceReload(AddReloadListenerEvent event) {
        volineEatTable = new VolineEatTable();
        spawnrateManager = new SpawnrateManager();
        event.addListener((IFutureReloadListener)volineEatTable);
        spawnrateManager.loadResources();
    }

    public static Map<Item, Map<Item, Integer>> getVolineEatTable() {
        if (volineEatTable == null) {
            throw new IllegalStateException("Can not retrieve VolineEatTable until resources have loaded once.");
        }
        return volineEatTable.getVolineEatTable();
    }

    public static Map<String, Map<String, SpawnrateManager.SpawnInfo>> getSpawnrateManager() {
        if (spawnrateManager == null) {
            spawnrateManager = new SpawnrateManager();
        }
        return spawnrateManager.getSpawnrates();
    }
}

