/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.init;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.infernalstudios.infernalexp.InfernalExpansion;
import org.infernalstudios.infernalexp.config.InfernalExpansionConfig;
import org.infernalstudios.infernalexp.init.IEItems;

public class IELootModifiers {
    public static final DeferredRegister<GlobalLootModifierSerializer<?>> LOOT_MODIFIERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.LOOT_MODIFIER_SERIALIZERS, (String)"infernalexp");
    public static final RegistryObject<GlobalLootModifierSerializer<HoglinLootModifier>> HOGLIN_LOOT_MODIFIER = LOOT_MODIFIERS.register("hoglin_loot_modifier", () -> new HoglinLootSerializer());

    public static void register(IEventBus eventBus) {
        LOOT_MODIFIERS.register(eventBus);
        InfernalExpansion.LOGGER.info("Infernal Expansion: Loot Modifiers Registered!");
    }

    private static class HoglinLootSerializer
    extends GlobalLootModifierSerializer<HoglinLootModifier> {
        private HoglinLootSerializer() {
        }

        public HoglinLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditionsIn) {
            return new HoglinLootModifier(conditionsIn);
        }

        public JsonObject write(HoglinLootModifier instance) {
            return null;
        }
    }

    private static class HoglinLootModifier
    extends LootModifier {
        protected HoglinLootModifier(ILootCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            if (!InfernalExpansionConfig.MobInteractions.USE_HOGCHOPS.getBoolean()) {
                return generatedLoot;
            }
            int numChops = 0;
            int numCookedChops = 0;
            for (ItemStack item : generatedLoot) {
                if (item.func_77969_a(Items.field_151147_al.func_190903_i())) {
                    numChops += item.func_190916_E();
                    continue;
                }
                if (!item.func_77969_a(Items.field_151157_am.func_190903_i())) continue;
                numCookedChops += item.func_190916_E();
            }
            generatedLoot.removeIf(x -> x.func_77969_a(Items.field_151147_al.func_190903_i()));
            generatedLoot.removeIf(x -> x.func_77969_a(Items.field_151157_am.func_190903_i()));
            generatedLoot.add(new ItemStack((IItemProvider)IEItems.COOKED_HOGCHOP.get(), numCookedChops));
            generatedLoot.add(new ItemStack((IItemProvider)IEItems.RAW_HOGCHOP.get(), numChops));
            return generatedLoot;
        }
    }
}

