/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.mixin.common;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import org.infernalstudios.infernalexp.access.FireTypeAccess;
import org.infernalstudios.infernalexp.blocks.GlowFireBlock;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractFireBlock.class})
public abstract class MixinAbstractFireBlock
extends Block {
    private MixinAbstractFireBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Inject(method={"getFireForPlacement"}, at={@At(value="HEAD")}, cancellable=true)
    private static void IE_getFireForPlacement(IBlockReader reader, BlockPos pos, CallbackInfoReturnable<BlockState> info) {
        if (GlowFireBlock.isGlowFireBase(reader.func_180495_p(pos.func_177977_b()).func_177230_c())) {
            info.setReturnValue((Object)((Block)IEBlocks.GLOW_FIRE.get()).func_176223_P());
        }
    }

    @Inject(method={"onEntityCollision"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;forceFireTicks(I)V")})
    private void IE_setCustomFires(BlockState state, World worldIn, BlockPos pos, Entity entityIn, CallbackInfo info) {
        FireTypeAccess access = (FireTypeAccess)entityIn;
        if (state.func_203425_a(Blocks.field_235335_bO_)) {
            access.setFireType(FireTypeAccess.KnownFireTypes.SOUL_FIRE);
        } else if (state.func_203425_a((Block)IEBlocks.GLOW_FIRE.get())) {
            access.setFireType(FireTypeAccess.KnownFireTypes.GLOW_FIRE);
        } else {
            access.setFireType(FireTypeAccess.KnownFireTypes.FIRE);
        }
        if (ModList.get().isLoaded("endergetic") && state.func_177230_c().getRegistryName().equals((Object)new ResourceLocation("endergetic", "ender_fire")) && state.func_177230_c() instanceof AbstractFireBlock) {
            access.setFireType(FireTypeAccess.KnownFireTypes.ENDER_FIRE);
        }
        if (ModList.get().isLoaded("byg")) {
            if (state.func_177230_c().getRegistryName().equals((Object)new ResourceLocation("byg", "boric_fire")) && state.func_177230_c() instanceof AbstractFireBlock) {
                access.setFireType(FireTypeAccess.KnownFireTypes.BORIC_FIRE);
            } else if (state.func_177230_c().getRegistryName().equals((Object)new ResourceLocation("byg", "cryptic_fire")) && state.func_177230_c() instanceof AbstractFireBlock) {
                access.setFireType(FireTypeAccess.KnownFireTypes.CRYPTIC_FIRE);
            }
        }
    }
}

