/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.network;

import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.network.NetworkEvent;
import org.infernalstudios.infernalexp.init.IEItems;

public class WhipReachPacket {
    private final UUID playerUUID;
    private final int targetEntityID;
    private final ItemStack stack;
    private static final Random random = new Random();

    public WhipReachPacket(UUID playerUUID, int target, ItemStack stack) {
        this.playerUUID = playerUUID;
        this.targetEntityID = target;
        this.stack = stack;
    }

    public static void encode(WhipReachPacket message, PacketBuffer buffer) {
        buffer.func_179252_a(message.playerUUID);
        buffer.func_150787_b(message.targetEntityID);
        buffer.func_150788_a(message.stack);
    }

    public static WhipReachPacket decode(PacketBuffer buffer) {
        return new WhipReachPacket(buffer.func_179253_g(), buffer.func_150792_a(), buffer.func_150791_c());
    }

    public static void handle(WhipReachPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity playerEntity = ((NetworkEvent.Context)context.get()).getSender();
            playerEntity.func_130014_f_().func_184148_a((PlayerEntity)playerEntity, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.4f + 1.2f));
            if (playerEntity != null && playerEntity.func_184102_h() != null) {
                ServerPlayerEntity player = playerEntity.func_184102_h().func_184103_al().func_177451_a(message.playerUUID);
                Entity target = playerEntity.func_130014_f_().func_73045_a(message.targetEntityID);
                double reach = player.func_233637_b_((Attribute)ForgeMod.REACH_DISTANCE.get()) + 1.0;
                if (player != null && target != null && player.func_70068_e(target) < reach * reach * (double)player.func_184825_o(0.0f)) {
                    player.func_71059_n(target);
                    player.func_130014_f_().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.4f + 1.2f));
                    int knockbackLevel = message.getActiveKnockback(message.stack);
                    ((LivingEntity)target).func_233627_a_(1.0f + (float)knockbackLevel * 0.5f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    private int getActiveKnockback(ItemStack stack) {
        if (stack.func_77973_b() != IEItems.BLINDSIGHT_TONGUE_WHIP.get()) {
            return 0;
        }
        ListNBT listnbt = stack.func_77986_q();
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundNBT = listnbt.func_150305_b(i);
            if (!compoundNBT.func_74779_i("id").equals("minecraft:knockback")) continue;
            return MathHelper.func_76125_a((int)compoundNBT.func_74762_e("lvl"), (int)0, (int)2);
        }
        return 0;
    }
}

