/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.util;

import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class NetherTeleportCommandUtil {
    public static BlockPos getSafePosition(ServerWorld world, BlockPos pos) {
        Direction direction = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)Direction.Axis.X);
        double shortestDistToOpen = -1.0;
        double shortestDistToFit = -1.0;
        BlockPos safePos = null;
        BlockPos tempPos = null;
        WorldBorder worldborder = world.func_175723_af();
        int dimHeight = world.func_234938_ad_();
        BlockPos.Mutable mutablePos = pos.func_239590_i_();
        for (BlockPos.Mutable currentPos : BlockPos.func_243514_a((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int minDimHeight = Math.min(dimHeight - 1, world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, currentPos.func_177958_n(), currentPos.func_177952_p()));
            if (!worldborder.func_177746_a((BlockPos)currentPos) || !worldborder.func_177746_a((BlockPos)currentPos.func_189534_c(direction, 1))) continue;
            currentPos.func_189534_c(direction.func_176734_d(), 1);
            for (int height = minDimHeight; height >= 0; --height) {
                int deltaHeight;
                currentPos.func_185336_p(height);
                if (!world.func_175623_d((BlockPos)currentPos)) continue;
                int currentHeight = height;
                while (height > 0 && world.func_175623_d((BlockPos)currentPos.func_189536_c(Direction.DOWN))) {
                    --height;
                }
                if (height + 4 > dimHeight - 1 || (deltaHeight = currentHeight - height) > 0 && deltaHeight < 3) continue;
                currentPos.func_185336_p(height);
                if (!NetherTeleportCommandUtil.checkRegionForPlacement(world, (BlockPos)currentPos, mutablePos, direction, 0)) continue;
                double currentDist = pos.func_177951_i((Vector3i)currentPos);
                if (NetherTeleportCommandUtil.checkRegionForPlacement(world, (BlockPos)currentPos, mutablePos, direction, -1) && NetherTeleportCommandUtil.checkRegionForPlacement(world, (BlockPos)currentPos, mutablePos, direction, 1) && (shortestDistToOpen == -1.0 || shortestDistToOpen > currentDist)) {
                    shortestDistToOpen = currentDist;
                    safePos = currentPos.func_185334_h();
                }
                if (shortestDistToOpen != -1.0 || shortestDistToFit != -1.0 && !(shortestDistToFit > currentDist)) continue;
                shortestDistToFit = currentDist;
                tempPos = currentPos.func_185334_h();
            }
        }
        if (shortestDistToOpen == -1.0 && shortestDistToFit != -1.0) {
            safePos = tempPos;
            shortestDistToOpen = shortestDistToFit;
        }
        if (shortestDistToOpen == -1.0 && !worldborder.func_177746_a(safePos = new BlockPos(pos.func_177958_n(), MathHelper.func_76125_a((int)pos.func_177956_o(), (int)70, (int)(dimHeight - 10)), pos.func_177952_p()).func_185334_h())) {
            return null;
        }
        return safePos;
    }

    private static boolean checkRegionForPlacement(ServerWorld world, BlockPos originalPos, BlockPos.Mutable offsetPos, Direction directionIn, int offsetScale) {
        Direction direction = directionIn.func_176746_e();
        for (int x = -1; x < 1; ++x) {
            for (int y = -1; y < 2; ++y) {
                offsetPos.func_239621_a_((Vector3i)originalPos, directionIn.func_82601_c() * x + direction.func_82601_c() * offsetScale, y, directionIn.func_82599_e() * x + direction.func_82599_e() * offsetScale);
                if (y < 0 && !world.func_180495_p((BlockPos)offsetPos).func_185904_a().func_76220_a()) {
                    return false;
                }
                if (y < 0 || world.func_175623_d((BlockPos)offsetPos)) continue;
                return false;
            }
        }
        return true;
    }
}

