/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.LongFunction;
import javax.annotation.Nonnull;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.ZoomLayer;
import org.infernalstudios.infernalexp.util.WorldSeedHolder;
import org.infernalstudios.infernalexp.world.dimension.ModNetherBiomeCollector;
import org.infernalstudios.infernalexp.world.dimension.ModNetherMasterLayer;

public class ModNetherBiomeProvider
extends BiomeProvider {
    public static final Codec<ModNetherBiomeProvider> MOD_NETHER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").orElseGet(WorldSeedHolder::getSeed).forGetter(biomeSource -> biomeSource.seed), (App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(biomeProvider -> biomeProvider.biomeRegistry), (App)Codec.intRange((int)1, (int)20).fieldOf("biome_size").orElse((Object)1).forGetter(biomeSource -> biomeSource.biomeSize)).apply((Applicative)instance, ModNetherBiomeProvider::new));
    public final long seed;
    private final int biomeSize;
    private final Layer biomeLayer;
    protected final Registry<Biome> biomeRegistry;

    public static void registerBiomeProvider() {
        Registry.func_218322_a((Registry)Registry.field_239689_aA_, (ResourceLocation)new ResourceLocation("infernalexp", "biome_provider"), MOD_NETHER_CODEC);
    }

    public ModNetherBiomeProvider(long seed, Registry<Biome> biomeRegistry, int size) {
        super(ModNetherBiomeCollector.netherBiomeCollection(biomeRegistry).stream().map(registryKey -> () -> (Biome)biomeRegistry.func_230516_a_(registryKey)));
        this.seed = seed;
        this.biomeLayer = ModNetherBiomeProvider.buildWorldProcedure(seed, size, biomeRegistry);
        this.biomeRegistry = biomeRegistry;
        this.biomeSize = size;
    }

    public static Layer buildWorldProcedure(long seed, int biomeSize, Registry<Biome> biomeRegistry) {
        IAreaFactory layerFactory = ModNetherBiomeProvider.build(salt -> new LazyAreaLayerContext(25, seed, salt), biomeSize, seed, biomeRegistry);
        return new Layer(layerFactory);
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> build(LongFunction<C> contextFactory, int biomeSize, long seed, Registry<Biome> biomeRegistry) {
        IAreaFactory layerFactory = new ModNetherMasterLayer(seed, biomeRegistry).func_202823_a((IExtendedNoiseRandom)contextFactory.apply(200L));
        for (int currentExtraZoom = 0; currentExtraZoom < biomeSize; ++currentExtraZoom) {
            layerFactory = (currentExtraZoom + 2) % 3 != 0 ? ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2001L + (long)currentExtraZoom), layerFactory) : ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2000L + (long)(currentExtraZoom * 31)), layerFactory);
        }
        return layerFactory;
    }

    public Biome func_225526_b_(int x, int y, int z) {
        int k = this.biomeLayer.field_215742_b.func_202678_a(x, z);
        Biome biome = (Biome)this.biomeRegistry.func_148745_a(k);
        if (biome == null) {
            if (SharedConstants.field_206244_b) {
                throw (IllegalStateException)Util.func_229757_c_((Throwable)new IllegalStateException("Unknown biome id: " + k));
            }
            return (Biome)this.biomeRegistry.func_230516_a_(BiomeRegistry.func_244203_a((int)0));
        }
        return biome;
    }

    @Nonnull
    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return MOD_NETHER_CODEC;
    }

    @Nonnull
    public BiomeProvider func_230320_a_(long seed) {
        return new ModNetherBiomeProvider(seed, this.biomeRegistry, this.biomeSize);
    }
}

