/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.carvers;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.CanyonWorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.infernalstudios.infernalexp.init.IEBlocks;

public class GlowstoneRavineCarver
extends CanyonWorldCarver {
    private final float[] heightToHorizontalStretchFactor = new float[256];

    public GlowstoneRavineCarver(Codec<ProbabilityConfig> p_i231916_1_) {
        super(p_i231916_1_);
        this.field_222718_j = ImmutableSet.of((Object)Blocks.field_235406_np_, (Object)Blocks.field_150426_aN, (Object)IEBlocks.DULLSTONE.get(), (Object)IEBlocks.DIMSTONE.get(), (Object)IEBlocks.GLOWDUST_SAND.get(), (Object)IEBlocks.GLOWDUST_STONE.get(), (Object[])new Block[]{(Block)IEBlocks.GLOWDUST.get(), (Block)IEBlocks.CRUMBLING_BLACKSTONE.get()});
    }

    public boolean func_225555_a_(IChunk chunk, Function<BlockPos, Biome> biomePos, Random random, int seaLevel, int chunkXOffset, int chunkZOffset, int chunkX, int chunkZ, BitSet carvingMask, ProbabilityConfig config) {
        int ravineLength = (this.func_222704_c() * 2 - 1) * 16;
        double x = chunkXOffset * 16 + random.nextInt(16);
        double z = chunkZOffset * 16 + random.nextInt(16);
        double y = this.findYPos(chunk, random, x, z);
        float yaw = random.nextFloat() * ((float)Math.PI * 2);
        float pitch = (random.nextFloat() - 0.5f) * 2.0f / 8.0f;
        float width = 1.0f;
        int maxLength = ravineLength - random.nextInt(ravineLength / 4);
        this.carveRavine(chunk, biomePos, random.nextLong(), seaLevel, chunkX, chunkZ, x, y, z, width, yaw, pitch, 0, maxLength, 3.0, carvingMask);
        return true;
    }

    private void carveRavine(IChunk chunk, Function<BlockPos, Biome> biomePos, long seed, int seaLevel, int chunkX, int chunkZ, double x, double y, double z, float width, float yaw, float pitch, int branchStartIndex, int branchCount, double yawMultiplier, BitSet p_227204_21_) {
        Random random = new Random(seed);
        float stretch = 1.0f;
        for (int y1 = 0; y1 < 256; ++y1) {
            if (y1 == 0 || random.nextInt(3) == 0) {
                stretch = 1.0f + random.nextFloat() * random.nextFloat();
            }
            this.heightToHorizontalStretchFactor[y1] = stretch * stretch;
        }
        float yawChange = 0.0f;
        float pitchChange = 0.0f;
        for (int i = branchStartIndex; i < branchCount; ++i) {
            double scaledYaw = 1.5 + (double)(MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)branchCount)) * width);
            double scaledPitch = scaledYaw * yawMultiplier;
            scaledYaw *= (double)random.nextFloat() * 0.25 + 0.75;
            scaledPitch *= (double)random.nextFloat() * 0.25 + 0.75;
            float deltaXZ = MathHelper.func_76134_b((float)pitch);
            float deltaY = MathHelper.func_76126_a((float)pitch);
            x += (double)(MathHelper.func_76134_b((float)yaw) * deltaXZ);
            y += (double)deltaY;
            z += (double)(MathHelper.func_76126_a((float)yaw) * deltaXZ);
            pitch *= 0.7f;
            pitch += pitchChange * 0.05f;
            yaw += yawChange * 0.05f;
            pitchChange *= 0.8f;
            yawChange *= 0.5f;
            pitchChange += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            yawChange += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (random.nextInt(4) == 0) continue;
            if (!this.func_222702_a(chunkX, chunkZ, x, z, i, branchCount, width)) {
                return;
            }
            this.func_227208_a_(chunk, biomePos, seed, seaLevel, chunkX, chunkZ, x, y, z, scaledYaw, scaledPitch, p_227204_21_);
        }
    }

    protected boolean func_222708_a(double scaledRelativeX, double scaledRelativeY, double scaledRelativeZ, int y) {
        return (scaledRelativeX * scaledRelativeX + scaledRelativeZ * scaledRelativeZ) * (double)this.heightToHorizontalStretchFactor[y - 1] + scaledRelativeY * scaledRelativeY / 6.0 >= 1.0;
    }

    private double findYPos(IChunk chunk, Random random, double x, double z) {
        for (int yCheck = 0; yCheck < 128; ++yCheck) {
            if (random.nextInt(3) == 0 || chunk.func_180495_p(new BlockPos(x, (double)yCheck, z)) != ((Block)IEBlocks.GLOWDUST_SAND.get()).func_176223_P()) continue;
            return yCheck - 5;
        }
        return 0.0;
    }

    protected boolean func_230358_a_(IChunk chunk, Function<BlockPos, Biome> p_230358_2_, BitSet carvingMask, Random rand, BlockPos.Mutable mutableBlockPos, BlockPos.Mutable p_230358_6_, BlockPos.Mutable p_230358_7_, int p_230358_8_, int p_230358_9_, int p_230358_10_, int posX, int posZ, int posX2, int posY, int posZ2, MutableBoolean isSurface) {
        int maskIndex = posX2 | posZ2 << 4 | posY << 8;
        if (carvingMask.get(maskIndex)) {
            return false;
        }
        carvingMask.set(maskIndex);
        mutableBlockPos.func_181079_c(posX, posY, posZ);
        if (this.func_222706_a(chunk.func_180495_p((BlockPos)mutableBlockPos))) {
            BlockState blockstate = posY <= 31 ? field_222717_i.func_206883_i() : field_222715_g;
            chunk.func_177436_a((BlockPos)mutableBlockPos, blockstate, false);
            return true;
        }
        return false;
    }
}

