/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.features;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.util.ShapeUtil;
import org.infernalstudios.infernalexp.world.gen.features.config.GlowSpikeFeatureConfig;

public class GlowSpikeFeature
extends Feature<GlowSpikeFeatureConfig> {
    public GlowSpikeFeature(Codec<GlowSpikeFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, GlowSpikeFeatureConfig config) {
        if (world.func_175623_d(pos) || world.func_180495_p(pos.func_177977_b()).func_177230_c() == IEBlocks.GLOWDUST_SAND.get() || world.func_180495_p(pos).func_177230_c() == Blocks.field_150353_l && world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150353_l) {
            int height = config.minHeight + random.nextInt(config.maxHeight - config.minHeight);
            int diameter = config.minDiameter + random.nextInt(config.maxDiameter - config.minDiameter);
            int xOffset = -config.maxXOffset + random.nextInt(config.maxXOffset * 2);
            int zOffset = -config.maxZOffset + random.nextInt(config.maxZOffset * 2);
            List<BlockPos> points = ShapeUtil.generateSolidCircle((float)diameter / 2.0f);
            for (BlockPos point : points) {
                BlockPos pointPos = new BlockPos(pos.func_177958_n() + point.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + point.func_177952_p());
                if (world.func_180495_p(pointPos.func_177977_b()).func_196958_f()) {
                    if (random.nextBoolean() && random.nextBoolean()) {
                        return this.generate(world, generator, random, pos.func_177977_b(), config);
                    }
                    return false;
                }
                if (world.func_180495_p(pointPos.func_177977_b()).func_177230_c() != Blocks.field_150353_l) continue;
                return this.generate(world, generator, random, pos.func_177977_b(), config);
            }
            for (BlockPos point : points) {
                this.placeGlowSpikeLine(world, pos.func_177982_a(point.func_177958_n(), 0, point.func_177952_p()), pos.func_177982_a(xOffset, height, zOffset), random, config);
            }
            return true;
        }
        return false;
    }

    private void placeGlowSpikeLine(ISeedReader world, BlockPos startPos, BlockPos endPos, Random random, GlowSpikeFeatureConfig config) {
        List<BlockPos> line = ShapeUtil.generateLine(startPos, endPos);
        for (int i = 0; i < line.size(); ++i) {
            BlockPos pos = line.get(i);
            if (pos.func_177956_o() >= 128 || world.func_180495_p(pos).equals(Blocks.field_150357_h.func_176223_P())) continue;
            float percentage = (float)i / (float)line.size() - config.blockDitheringAmount / 2.0f + random.nextFloat() * config.blockDitheringAmount;
            if ((double)percentage <= 0.33) {
                if (config.darkAtTop) {
                    world.func_180501_a(pos, Blocks.field_150426_aN.func_176223_P(), 2);
                    continue;
                }
                world.func_180501_a(new BlockPos((Vector3i)pos), ((Block)IEBlocks.DULLSTONE.get()).func_176223_P(), 2);
                continue;
            }
            if ((double)percentage > 0.33 && (double)percentage <= 0.66) {
                world.func_180501_a(new BlockPos((Vector3i)pos), ((Block)IEBlocks.DIMSTONE.get()).func_176223_P(), 2);
                continue;
            }
            if (config.darkAtTop) {
                world.func_180501_a(new BlockPos((Vector3i)pos), ((Block)IEBlocks.DULLSTONE.get()).func_176223_P(), 2);
                continue;
            }
            world.func_180501_a(new BlockPos((Vector3i)pos), Blocks.field_150426_aN.func_176223_P(), 2);
        }
    }
}

