/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.features;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.util.ShapeUtil;

public class HangingGiantBrownMushroomFeature
extends Feature<NoFeatureConfig> {
    private static final int minSize = 3;
    private static final int maxSize = 7;
    private static final ResourceLocation enhancedMushroomsBrownStem = new ResourceLocation("enhanced_mushrooms", "brown_mushroom_stem");

    public HangingGiantBrownMushroomFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunk, Random random, BlockPos pos, NoFeatureConfig config) {
        if (!world.func_175623_d(pos) || world.func_180495_p(pos.func_177984_a()) != ((Block)IEBlocks.DULLSTONE.get()).func_176223_P()) {
            return false;
        }
        int size = 3 + random.nextInt(4);
        BlockState enhancedMushroomsBrownStemBlockState = null;
        if (ModList.get().isLoaded("enhanced_mushrooms")) {
            enhancedMushroomsBrownStemBlockState = ((Block)ForgeRegistries.BLOCKS.getValue(enhancedMushroomsBrownStem)).func_176223_P();
        }
        for (int y = 0; y <= size; ++y) {
            if (enhancedMushroomsBrownStemBlockState != null) {
                world.func_180501_a(pos.func_177979_c(y), enhancedMushroomsBrownStemBlockState, 2);
                continue;
            }
            world.func_180501_a(pos.func_177979_c(y), Blocks.field_196706_do.func_176223_P(), 2);
        }
        for (BlockPos point : ShapeUtil.generateSolidCircle((float)(size / 2) + 1.0f)) {
            world.func_180501_a(pos.func_177982_a(point.func_177958_n(), point.func_177956_o() - size, point.func_177952_p()), Blocks.field_150420_aW.func_176223_P(), 2);
        }
        return true;
    }
}

