/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.features;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import org.infernalstudios.infernalexp.blocks.PlantedQuartzBlock;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.world.gen.features.config.PlantedQuartzFeatureConfig;

public class PlantedQuartzFeature
extends Feature<PlantedQuartzFeatureConfig> {
    public PlantedQuartzFeature(Codec<PlantedQuartzFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random random, BlockPos pos, PlantedQuartzFeatureConfig config) {
        int i = 0;
        int amount = 15;
        for (int j = 0; j < 256; ++j) {
            BlockPos blockpos = pos.func_177982_a(random.nextInt(10) - random.nextInt(20), random.nextInt(4) - random.nextInt(8), random.nextInt(10) - random.nextInt(20));
            ArrayList<BlockState> allowedBlockstates = new ArrayList<BlockState>(6);
            BlockState iterState = (BlockState)((PlantedQuartzBlock)IEBlocks.PLANTED_QUARTZ.get()).func_176223_P().func_206870_a((Property)PlantedQuartzBlock.field_196366_M, (Comparable)AttachFace.FLOOR);
            if (iterState.func_196955_c((IWorldReader)worldIn, blockpos)) {
                allowedBlockstates.add(iterState);
            }
            if ((iterState = (BlockState)((PlantedQuartzBlock)IEBlocks.PLANTED_QUARTZ.get()).func_176223_P().func_206870_a((Property)PlantedQuartzBlock.field_196366_M, (Comparable)AttachFace.CEILING)).func_196955_c((IWorldReader)worldIn, blockpos)) {
                allowedBlockstates.add(iterState);
            }
            for (int k = 0; k < 4; ++k) {
                Direction iterDirection = i == 0 ? Direction.NORTH : (i == 1 ? Direction.SOUTH : (i == 2 ? Direction.EAST : Direction.WEST));
                iterState = (BlockState)((BlockState)((PlantedQuartzBlock)IEBlocks.PLANTED_QUARTZ.get()).func_176223_P().func_206870_a((Property)PlantedQuartzBlock.field_196366_M, (Comparable)AttachFace.CEILING)).func_206870_a((Property)PlantedQuartzBlock.field_185512_D, (Comparable)iterDirection);
                if (!iterState.func_196955_c((IWorldReader)worldIn, blockpos)) continue;
                allowedBlockstates.add(iterState);
            }
            if (allowedBlockstates.size() < 1) continue;
            BlockState state = (BlockState)allowedBlockstates.get(random.nextInt(allowedBlockstates.size()));
            if (worldIn.func_175623_d(blockpos) && state.func_196955_c((IWorldReader)worldIn, blockpos)) {
                float chance = random.nextFloat();
                if (this.findOre(worldIn, blockpos) || chance > config.chanceToFail) {
                    worldIn.func_180501_a(blockpos, state, 2);
                    ++i;
                }
            }
            if (i < amount) continue;
            return true;
        }
        return false;
    }

    public boolean findOre(ISeedReader world, BlockPos pos) {
        int radius = 3;
        for (int x = pos.func_177958_n() - 3; x < pos.func_177958_n() + 3; ++x) {
            for (int y = pos.func_177956_o() - 3; y < pos.func_177956_o() + 3; ++y) {
                for (int z = pos.func_177952_p() - 3; z < pos.func_177952_p() + 3; ++z) {
                    if (!world.func_180495_p(new BlockPos(x, y, z)).func_177230_c().equals(Blocks.field_196766_fg)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

