/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.features;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import org.infernalstudios.infernalexp.init.IEBlocks;
import org.infernalstudios.infernalexp.util.ShapeUtil;

public class SinkHoleFeature
extends Feature<NoFeatureConfig> {
    private static final int minRadius = 2;
    private static final int maxRadius = 4;

    public SinkHoleFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        int y;
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        if (!world.func_175623_d((BlockPos)mutableBlockPos) || world.func_180495_p((BlockPos)mutableBlockPos.func_189536_c(Direction.DOWN)).func_177230_c() != IEBlocks.GLOWDUST_SAND.get()) {
            return false;
        }
        int radius = 2 + random.nextInt(2);
        int depth = 10 + random.nextInt(6);
        mutableBlockPos.func_189533_g((Vector3i)pos);
        for (int y2 = 1; y2 < depth; ++y2) {
            mutableBlockPos.func_189536_c(Direction.DOWN);
            if (!world.func_180495_p((BlockPos)mutableBlockPos).func_203425_a(Blocks.field_150350_a)) continue;
            return false;
        }
        for (BlockPos point : ShapeUtil.generateSolidCircle(radius + 1)) {
            mutableBlockPos.func_189533_g((Vector3i)pos);
            mutableBlockPos.func_196234_d(point.func_177958_n(), point.func_177956_o(), point.func_177952_p());
            for (y = 0; y < 3; ++y) {
                world.func_180501_a((BlockPos)mutableBlockPos.func_189536_c(Direction.DOWN), ((Block)IEBlocks.GLOWDUST_SAND.get()).func_176223_P(), 2);
            }
        }
        for (BlockPos point : ShapeUtil.generateSolidCircle(radius)) {
            mutableBlockPos.func_189533_g((Vector3i)pos);
            mutableBlockPos.func_196234_d(point.func_177958_n(), point.func_177956_o(), point.func_177952_p());
            mutableBlockPos.func_189536_c(Direction.DOWN);
            world.func_180501_a((BlockPos)mutableBlockPos, ((Block)IEBlocks.TRAPPED_GLOWDUST_SAND.get()).func_176223_P(), 2);
            for (y = 2; y < depth; ++y) {
                mutableBlockPos.func_189536_c(Direction.DOWN);
                this.carveSpot(world, generator, mutableBlockPos);
            }
        }
        for (BlockPos point : ShapeUtil.generateSolidSphere(radius)) {
            mutableBlockPos.func_189533_g((Vector3i)pos);
            mutableBlockPos.func_196234_d(point.func_177958_n(), point.func_177956_o(), point.func_177952_p());
            mutableBlockPos.func_189534_c(Direction.DOWN, depth + 1);
            this.carveSpot(world, generator, mutableBlockPos);
        }
        return true;
    }

    private void carveSpot(ISeedReader world, ChunkGenerator generator, BlockPos.Mutable mutableBlockPos) {
        if (world.func_180495_p((BlockPos)mutableBlockPos).func_204520_s().func_206888_e()) {
            if (mutableBlockPos.func_177956_o() < generator.func_230356_f_()) {
                world.func_180501_a((BlockPos)mutableBlockPos, Blocks.field_150353_l.func_176223_P(), 3);
            } else {
                world.func_180501_a((BlockPos)mutableBlockPos, Blocks.field_150350_a.func_176223_P(), 3);
            }
        }
    }
}

