/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.structures;

import com.mojang.serialization.Codec;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import org.infernalstudios.infernalexp.init.IEBlocks;

public abstract class IEStructure<F extends IFeatureConfig>
extends Structure<F> {
    public IEStructure(Codec<F> codec) {
        super(codec);
    }

    public abstract StructureSeparationSettings getSeparationSettings();

    public abstract boolean shouldTransformLand();

    public static int getYPos(ChunkGenerator chunkGenerator, int x, int z, SharedSeedRandom random) {
        int y;
        IBlockReader blockColumn = chunkGenerator.func_230348_a_(x, z);
        BlockPos pos = new BlockPos(x, y, z);
        for (y = chunkGenerator.func_230356_f_() + random.nextInt(chunkGenerator.func_230355_e_() - 2 - chunkGenerator.func_230356_f_()); y > chunkGenerator.func_230356_f_(); --y) {
            BlockState checkAir = blockColumn.func_180495_p(pos.func_177979_c(y));
            BlockState checkBlock = blockColumn.func_180495_p(pos.func_177979_c(y + 1));
            if (!checkAir.func_196958_f() || !checkBlock.func_203425_a((Block)IEBlocks.GLOWDUST_SAND.get()) && !checkBlock.func_224755_d(blockColumn, pos.func_177979_c(y), Direction.UP)) continue;
            return y;
        }
        return 0;
    }

    public static abstract class IEStart<F extends IFeatureConfig>
    extends StructureStart<F> {
        public IEStart(Structure<F> structure, int chunkX, int chunkY, MutableBoundingBox mutableBoundingBox, int reference, long seed) {
            super(structure, chunkX, chunkY, mutableBoundingBox, reference, seed);
        }

        public static int getYPos(ChunkGenerator chunkGenerator, int x, int z, SharedSeedRandom random) {
            int y;
            IBlockReader blockColumn = chunkGenerator.func_230348_a_(x, z);
            BlockPos pos = new BlockPos(x, y, z);
            for (y = chunkGenerator.func_230356_f_() + random.nextInt(chunkGenerator.func_230355_e_() - 2 - chunkGenerator.func_230356_f_()); y > chunkGenerator.func_230356_f_(); --y) {
                BlockState checkAir = blockColumn.func_180495_p(pos.func_177979_c(y));
                BlockState checkBlock = blockColumn.func_180495_p(pos.func_177979_c(y + 1));
                if (!checkAir.func_196958_f() || !checkBlock.func_203425_a((Block)IEBlocks.GLOWDUST_SAND.get()) && !checkBlock.func_224755_d(blockColumn, pos.func_177979_c(y), Direction.UP)) continue;
                return y;
            }
            return 0;
        }
    }
}

