/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.structures;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import org.infernalstudios.infernalexp.world.gen.structures.IEStructure;

public class StriderAltarStructure
extends IEStructure<NoFeatureConfig> {
    public StriderAltarStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    @Override
    public StructureSeparationSettings getSeparationSettings() {
        return new StructureSeparationSettings(10, 5, 80837592);
    }

    @Override
    public boolean shouldTransformLand() {
        return true;
    }

    protected boolean func_230363_a_(ChunkGenerator chunkGenerator, BiomeProvider biomeProvider, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig config) {
        if (super.func_230363_a_(chunkGenerator, biomeProvider, seed, chunkRandom, chunkX, chunkZ, biome, chunkPos, (IFeatureConfig)config)) {
            BlockPos.Mutable mutable = new BlockPos.Mutable(chunkX << 4, chunkGenerator.func_230356_f_(), chunkZ << 4);
            IBlockReader blockView = chunkGenerator.func_230348_a_(mutable.func_177958_n(), mutable.func_177952_p());
            int minValidSpace = 20;
            int maxHeight = Math.min(chunkGenerator.func_230355_e_(), chunkGenerator.func_230356_f_() + minValidSpace);
            while (mutable.func_177956_o() < maxHeight) {
                BlockState state = blockView.func_180495_p((BlockPos)mutable);
                if (!state.func_196958_f()) {
                    return false;
                }
                mutable.func_189536_c(Direction.UP);
            }
        } else {
            return false;
        }
        return true;
    }

    public static class Start
    extends IEStructure.IEStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structure, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int reference, long seed) {
            super(structure, chunkX, chunkZ, mutableBoundingBox, reference, seed);
        }

        public int getLavaY(ChunkGenerator chunkGenerator, int x, int z) {
            int y = chunkGenerator.func_230356_f_();
            IBlockReader blockColumn = chunkGenerator.func_230348_a_(x, z);
            BlockPos pos = new BlockPos(x, y, z);
            if (blockColumn.func_180495_p(pos).func_200132_m()) {
                return 0;
            }
            for (int topDown = 1; topDown <= y; ++topDown) {
                BlockState checkLava = blockColumn.func_180495_p(pos.func_177979_c(topDown));
                BlockState checkBlock = blockColumn.func_180495_p(pos.func_177979_c(topDown + 1));
                if (!checkLava.func_203425_a(Blocks.field_150353_l) || !checkBlock.func_224755_d(blockColumn, pos.func_177979_c(y), Direction.UP)) continue;
                return y - topDown;
            }
            return 0;
        }

        public void func_230364_a_(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig config) {
            int x = chunkX << 4;
            int z = chunkZ << 4;
            BlockPos pos = new BlockPos(x, this.getLavaY(chunkGenerator, x, z), z);
            if (pos.func_177956_o() != 0) {
                JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(new ResourceLocation("infernalexp", "strider_altar/start_pool")), 1), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)templateManager, (BlockPos)pos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)false);
                this.func_202500_a();
            }
        }
    }
}

