/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.surfacebuilders;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class DeltaShoresSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    public DeltaShoresSurfaceBuilder(Codec<SurfaceBuilderConfig> p_i232136_1_) {
        super(p_i232136_1_);
    }

    public void buildSurface(Random random, IChunk chunk, Biome biome, int x, int z, int terrainHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        this.buildSurface(random, chunk, biome, x, z, terrainHeight, noise, defaultBlock, defaultFluid, config.func_204108_a(), config.func_204109_b(), config.func_204110_c(), seaLevel);
    }

    protected void buildSurface(Random random, IChunk chunk, Biome biome, int x, int z, int terrainHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, BlockState topBlock, BlockState middleBlock, BlockState underwaterBlock, int seaLevel) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int depth = -1;
        int siltMixThreshold = 63;
        int middleBlockExtraDepth = (int)(noise / 3.0 + 1.0 + random.nextDouble() * 0.25);
        for (int y = terrainHeight; y >= seaLevel; --y) {
            mutable.func_181079_c(x, y, z);
            BlockState currentBlockInWorld = chunk.func_180495_p((BlockPos)mutable);
            if (currentBlockInWorld.func_196958_f()) {
                depth = -1;
                continue;
            }
            if (!currentBlockInWorld.func_204520_s().func_206888_e() || currentBlockInWorld.func_177230_c() == Blocks.field_150357_h) continue;
            if (depth == -1 && y > seaLevel) {
                chunk.func_177436_a((BlockPos)mutable, topBlock, false);
            } else if (depth <= 3 + middleBlockExtraDepth) {
                chunk.func_177436_a((BlockPos)mutable, middleBlock, false);
            } else if (y <= siltMixThreshold) {
                float percentage = (float)y / 63.0f - (float)noise / 6.5f;
                if ((double)percentage <= 0.1) {
                    chunk.func_177436_a((BlockPos)mutable, topBlock, false);
                } else {
                    chunk.func_177436_a((BlockPos)mutable, underwaterBlock, false);
                }
            } else {
                chunk.func_177436_a((BlockPos)mutable, underwaterBlock, false);
            }
            ++depth;
        }
    }
}

