/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila;

import com.mojang.blaze3d.platform.InputConstants;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.addons.core.CorePlugin;
import mcp.mobius.waila.api.config.WailaConfig;
import mcp.mobius.waila.gui.HomeConfigScreen;
import mcp.mobius.waila.impl.ObjectDataCenter;
import mcp.mobius.waila.impl.config.PluginConfig;
import mcp.mobius.waila.overlay.OverlayRenderer;
import mcp.mobius.waila.overlay.WailaTickHandler;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmlclient.ConfigGuiHandler;
import net.minecraftforge.fmlclient.registry.ClientRegistry;

@Mod.EventBusSubscriber(modid="waila", value={Dist.CLIENT})
public class WailaClient {
    public static KeyMapping openConfig;
    public static KeyMapping showOverlay;
    public static KeyMapping toggleLiquid;
    public static KeyMapping showDetails;
    public static boolean hideModName;

    public static void initClient() {
        ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((minecraft, screen) -> new HomeConfigScreen((Screen)screen)));
        openConfig = new KeyMapping("key.waila.config", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM.m_84895_(320), "Jade");
        showOverlay = new KeyMapping("key.waila.show_overlay", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM.m_84895_(321), "Jade");
        toggleLiquid = new KeyMapping("key.waila.toggle_liquid", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM.m_84895_(322), "Jade");
        showDetails = new KeyMapping("key.waila.show_details", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM.m_84895_(340), "Jade");
        ClientRegistry.registerKeyBinding((KeyMapping)openConfig);
        ClientRegistry.registerKeyBinding((KeyMapping)showOverlay);
        ClientRegistry.registerKeyBinding((KeyMapping)toggleLiquid);
        ClientRegistry.registerKeyBinding((KeyMapping)showDetails);
    }

    @SubscribeEvent
    public static void onKeyPressed(InputEvent.KeyInputEvent event) {
        WailaConfig.DisplayMode mode;
        if (openConfig == null || showOverlay == null || toggleLiquid == null) {
            return;
        }
        if (event.getAction() != 1) {
            return;
        }
        if (openConfig.m_90857_()) {
            Waila.CONFIG.invalidate();
            Minecraft.m_91087_().m_91152_((Screen)new HomeConfigScreen(null));
        }
        if (showOverlay.m_90857_() && (mode = Waila.CONFIG.get().getGeneral().getDisplayMode()) == WailaConfig.DisplayMode.TOGGLE) {
            Waila.CONFIG.get().getGeneral().setDisplayTooltip(!Waila.CONFIG.get().getGeneral().shouldDisplayTooltip());
        }
        if (toggleLiquid.m_90857_()) {
            Waila.CONFIG.get().getGeneral().setDisplayFluids(!Waila.CONFIG.get().getGeneral().shouldDisplayFluids());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTooltip(ItemTooltipEvent event) {
        if (!hideModName && PluginConfig.INSTANCE.get(CorePlugin.CONFIG_ITEM_MOD_NAME, false)) {
            String name = String.format(Waila.CONFIG.get().getFormatting().getModName(), ModIdentification.getModName(event.getItemStack()));
            event.getToolTip().add(new TextComponent(name));
        }
        if (Waila.CONFIG.get().getGeneral().isDebug() && event.getItemStack().m_41782_()) {
            event.getToolTip().add(NbtUtils.m_178061_((Tag)event.getItemStack().m_41783_()));
        }
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            OverlayRenderer.renderOverlay();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            WailaTickHandler.instance().tickClient();
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        ObjectDataCenter.serverConnected = false;
    }
}

